#include "mbed.h"
#include "N5110.h"
#include "BMP180.h"
#include "beep.h"

BMP180 bmp180(p28,p27);              // To declear sensor intance
Serial serial(USBTX,USBRX);
Beep buzzer(p21);                    
N5110 lcd(p7,p8,p9,p10,p11,p13,p26); // Can also power (VCC) directly from VOUT (3.3 V) - // Can give better performance due to current limitation from GPIO pin
InterruptIn unitButton(p17);
InterruptIn sleepButton(p15);
AnalogIn batteryIndicator(p16);
DigitalOut led2(p23);
DigitalOut led1(p24);
Measurement measurement;
Ticker timer;
Ticker timer2;

BusOut leds(LED1, LED2, LED3, LED4); // Busout for leds


DigitalOut sce(p8);
SPI spi(p11,NC,p13);
DigitalOut pwr(p7);
DigitalOut dc(p10);
PwmOut led(p26);

void C();
void clearRAM();
void turnOfDisplay();
void turnOnDisplay();
void batteryLife(float);
void setBrightness(float brightness);
void F();
int unitButtonFlag = 0;
int CFlag =0;
int sleepButtonFlag =0;


// Function for temperature warning
void warning()
{
    if ( measurement.temperatureCel >= 30 ) {
        buzzer.beep(1000,0.3);
        lcd.printString("WARNING!", 15,15);
        lcd.refresh();
    } else {
        lcd.printString("          ", 15,15);
        lcd.refresh();
    }
}

// Function to put device into sleep mode by pressing button
void sleepFunction()
{
    if(sleepButtonFlag == 6) {
        sleepButtonFlag = 5;
    } else if (sleepButtonFlag == 5) {
        sleepButtonFlag =4;
    } else if (sleepButtonFlag ==4) {
        sleepButtonFlag =3;
    } else if (sleepButtonFlag==3) {
        sleepButtonFlag=2;
    } else if (sleepButtonFlag ==2) {
        sleepButtonFlag =1;
    } else if (sleepButtonFlag ==1) {
        sleepButtonFlag =0;
    } else {
        sleepButtonFlag =6;
    }
}


// Function to select unit
void unitFunction()
{

    if(unitButtonFlag == 1) {
        unitButtonFlag = 0;
        F();
    } else {
        unitButtonFlag = 1;
        C();
    }
}

void timeValue()
{
    F();
    C();
    lcd.refresh();
}

int main()
{
    bmp180.init();        // first need to initialise display
    lcd.init();
    // lcd.setBrightness(0);
    timer.attach(&warning,0.5);
    timer2.attach(&timeValue, 60.0);
    batteryLife(batteryIndicator);
    unitButton.rise(&unitFunction); //   Measurement measurement;  // measurement structure declared in BMP180 class
    sleepButton.rise(&sleepFunction);
    timeValue();
    lcd.refresh();
    
    // button.rise(&buttonPressed); // Event generated on rising edge

    while(1) {

        if(sleepButtonFlag == 6) {
            turnOnDisplay();
            lcd.setBrightness(0.2);
            lcd.refresh();
        } else if (sleepButtonFlag == 5) {
            lcd.setBrightness(0.4);
        } else if (sleepButtonFlag ==4) {
            lcd.setBrightness(0.6);
        } else if (sleepButtonFlag==3) {
            lcd.setBrightness(0.8);
        } else if (sleepButtonFlag==2) {
            lcd.setBrightness (1);
        } else if (sleepButtonFlag==1) {
            turnOfDisplay();
            lcd.clear();
            buzzer.nobeep();
            sleep();
        }
    }
}

// Display the temperature readings in fahrenheit
void F()
{
    char buffer[14];  // each character is 6 pixels wide, screen is 84 pixels (84/6 = 14) // so can display a string of a maximum 14 characters in length // or create formatted strings - ensure they aren't more than 14 characters long

    measurement = bmp180.readValues(); // read values (T in Celsius and P in mb) and print over serial port  //serial.printf("T = %.2f C P = %.2f mb\n",measurement.temperature,measurement.pressure);
    //wait(0.1);  // short delau until next reading

    int length = sprintf(buffer,"T = %.2f F",measurement.temperatureFeh); // print formatted data to buffer // it is important the format specifier ensures the length will fit in the buffer
    if (length <= 14)  // if string will fit on display
        lcd.printString(buffer,0,1);           // display on screen

    length = sprintf(buffer,"P = %.2f mb",measurement.pressure);
    if (length <= 14)
        lcd.printString(buffer,0,2);
    lcd.refresh();

}


//  Function that displays the temperature in Celsius
void C()
{


    char buffer[14];  // each character is 6 pixels wide, screen is 84 pixels (84/6 = 14) // so can display a string of a maximum 14 characters in length // or create formatted strings - ensure they aren't more than 14 characters long

    measurement = bmp180.readValues(); // read values (T in Celsius and P in mb) and print over serial port
    //wait(0.1);  // short delau until next reading

    int length = sprintf(buffer,"T = %.2f C",measurement.temperatureCel); // print formatted data to buffer // it is important the format specifier ensures the length will fit in the buffer
    if (length <= 14)  // if string will fit on display
        lcd.printString(buffer,0,1);           // display on screen

    length = sprintf(buffer,"P = %.2f mb",measurement.pressure);
    if (length <= 14)
        lcd.printString(buffer,0,2);
    lcd.refresh();

}


// This function uses a voltage in from a potential divider which is connected to the battery
void batteryLife(float voltageIn)
{
    if (voltageIn >=2.5) {
        led2 =0;
        led1 =1;
    }
    if (voltageIn <=2.5) {
        led1= 0;
        led2= 1;
    }
}

void turnOfDisplay()
{
    setBrightness(0.0);
    clearRAM();

}

void turnOnDisplay()
{
    setBrightness(1.0);
    pwr.write(1);

}

void setBrightness(float brightness)
{
    if(brightness < 0.0) {
        brightness = 0.0;
    }
    if (brightness > 1.0) {
        brightness = 1.0;
    }
    led.write(brightness);
}
void clearRAM()
{
    int i;
    sce.write(0);
    for(i =0; i < 504; i++) {
        spi.write(0x00);
    }

}