#include "mbed.h"
#include "BMP085.h"

BMP085 bmp085(p9, p10);

DigitalOut myled(LED1);
Serial pc(USBTX, USBRX);
float get_altitude(float pressure);
Timer t;
Serial xbee1(p13, p14);

LocalFileSystem local("local");                    //////setting the destination of the file that will be saved
float altitude,Max_altitude,altitude_node,pressure,Temperature;
int main()
{
    pc.baud(9600);
    xbee1.baud(9600);

    while(1)
    {  xbee1.printf("select any button to start operation\r\n");
       while(!xbee1.readable()/*||!pc.readable()*/);
            xbee1.getc();
    
        t.reset();
        t.start();
        FILE *fp=fopen("/local/out.xls","a");
         bmp085.update();
        //Temperature=alt_sensor.get_temperature();
        //pressure=alt_sensor.get_pressure();
        altitude_node=get_altitude(bmp085.get_pressure());
        Max_altitude=0;
        while(1){
            if(xbee1.readable()) {
                xbee1.getc();
                break;
                }
                bmp085.update();
                //Temperature=alt_sensor.get_temperature();
                //pressure=alt_sensor.get_pressure();
                altitude=get_altitude(bmp085.get_pressure())-altitude_node;
                if(Max_altitude<altitude){
                     Max_altitude=altitude;
                }
                xbee1.printf("altitude:%f Max_alt%f t:%f\r\n",altitude,Max_altitude,t.read());                  
                fprintf(fp,"%f \t %f \t %f \t %f \t %f\r\n",altitude,Max_altitude,pressure,Temperature,t.read());
                pc.printf("altitude:%f Max_alt%f t:%f\r\n",altitude,Max_altitude,t.read());  
            }
            fclose(fp);
    }
}



float get_altitude(float pressure){
    const float p0 = 1013.25;     // Pressure at sea level (Pa)
    float altitude;

    // Add this into loop(), after you've calculated the pressure
    altitude = (float)44330 * (1 - (float)pow(((double) pressure/p0), 0.190295));
    return altitude;
    }
