#include "mbed.h"
#include "stdio.h"
#include "stdlib.h"
#include "string"
AnalogIn Volts(p20);
PwmOut BLDCM1(p21);
PwmOut BLDCM2(p22);
PwmOut BLDCM3(p23);
PwmOut BLDCM4(p24);
Serial pc(USBTX, USBRX);

//red right p21
//blue right p22
//white left p23
//red left p24

// -----------> Make SURE!! each ESC is grounded on mbeds ground!!!!!!!!!! <------------


float val;

int main() {
    val =0.001;
    // Most ESC take standard servo commands so that is a 50hz signal and listens between 1ms and 3ms pulsewidth
    BLDCM1.period_ms(20);
    BLDCM2.period_ms(20);
    BLDCM3.period_ms(20);
    BLDCM4.period_ms(20);
    ////////////////////////////////
    while (1) {


        //Initailize motors

       if(pc.readable()){    
       switch (pc.getc()) {
            case 'u':
                val += 0.00005;
                break;
            case 'd':
                val -= 0.00005;
                break;
            case 'w':
                val += 0.00001;
                break;
            case 'x':
                val -= 0.00001;
                break;
            case 's':
                val = 0.001;
                break;
            case 'm':
                val = 0.0018;
                break;
             case 'l':
                val=0.5;
                break;
        }
        }
           
        BLDCM1.pulsewidth(val);
        BLDCM2.pulsewidth(val);
        BLDCM3.pulsewidth(val);
        BLDCM4.pulsewidth(val);
        wait(0.25);
        pc.printf("Volts (%f) Pulsewidth (%f) RPM (%f) \r\n",(((val*1000)*12)),(val),(((val*1000)*1200)));

    }
}