#ifndef MBED_SpaceSsensor_H
#define MBED_SpaceSsensor_H
//#endif
#include "mbed.h"
#include "iostream"
#include "math.h"
using namespace std;

class SpaceSensor {
public:
    SpaceSensor(PinName p_tx, PinName p_rx);
/**********************************************************************************************************************/    
    /*4.3.1 Commands for Reading Filtered Sensor Data
    These commands return sensor data which has been filtered using a Kalman filter. None of these commands take any
    parameters, they only return data.
    */
/**********************************************************************************************************************/
    void ReadfilteredtaredQuaternion(float *Quaternion);
    void ReadfilteredtaredEulerAngles(float *EulerAngles);
    void ReadfilteredtaredRotationMatrix(float *RotationMatrix);
    void ReadfilteredtaredAxisAngle(float *Axis,float *Angle);
    void ReadfilteredtaredTwoVector(float *Forward,float *Down);
    
    void Readfilteredgyrorates(float *Quaternion);
    
    void ReadfiltereduntaredQuaternion(float *Quaternion);
    void ReadfiltereduntaredEulerAngles(float *EulerAngles);
    void ReadfiltereduntaredRotationMatrix(float *RotationMatrix);
    void ReadfiltereduntaredAxisAngle(float *Axis,float *Angle);
    void ReadfiltereduntaredTwoVector(float *Forward,float *Down);
    
    void ReadfilteredtaredForwardandDownVectors(float *Forward,float *Down);
    void ReadfilteredNorthEarthVectors(float *North,float *Earth);
/**********************************************************************************************************************/    
    /*4.3.2 Commands for Interfacing with Electronic Systems*/
/**********************************************************************************************************************/    
    void Setinterrupttype(int mode);
    void Readinterrupttype(int *interrupttype);
    void Readinterruptstatus(int *interruptstatus);
/**********************************************************************************************************************/    
    /*4.3.3 Commands for Reading Normalized Sensor Data
    These commands return sensor data which has been converted from a raw form. In the case of the normalized
    accelerometer and compass, the data returned are unit vectors, and as such, have no magnitude data associated with
    them. For data that represents real world quantities, both the unnormalized accelerometer command and unnormalized
    compass command return data in units of g and gauss respectively. Normalized gyro data is returned in radians/sec.
    */
/**********************************************************************************************************************/    
    void Readall(float *gyro,float *accelerometer,float *compass);
    void Readgyros(float *gyro);
    void Readaccelerometer(float *accelerometer);
    void Readcompass(float *compass);
    void ReadtemperatureC(float *temp);
    void ReadtemperatureF(float *temp);
    void Readconfidencefactor(float *confidencefactor);
    void Readaccelerometerunnormalized(float *accelunnormalized);
    void Readcompassunnormalized(float *compassunnormalized);
/**********************************************************************************************************************/    
    /*4.3.4 Commands for Reading Raw Sensor Data
    These commands return sensor data just as it was when it was read from each sensor. None of these commands take any
    parameters, they only return data.
    */
/**********************************************************************************************************************/    
    void Readallraw(float *gyro,float *accelerometer,float *compass);
    void Readgyroraw(float *gyro);
    void Readaccelerometerraw(float *accelerometer);
    void Readcompassraw(float *compass);
/**********************************************************************************************************************/    
    /*4.3.5 Commands for Setting Filter Parameters
    These commands allow the configuration of parameters associated with the Kalman filter. Most of these commands
    take parameters, none return any data.
    */
/**********************************************************************************************************************/    
    void Tarewithcurrentorientation();
    void Tarewithquaternion(float Quaternion[4]);
    void Tarewithrotationmatrix(float RotationMatrix[9]);
    void SetStaticRhoModeAccelerometer(float rho);
    void SetConfidenceRhoModeAccelerometer(float min,float max);
    void SetStaticRhoModeCompass(float rho);
    void SetConfidenceRhoModeCompass(float min, float max);
    void SetDesiredUpdateRate(int t);
    void SetMultiReferenceVectorsWithCurrentOrientation();
    void SetReferenceVectorMode(int mode);
    void SetOversampleRate(int rate);
    void EnableDisablegyros(int mode);
    void EnableDisableAccelerometer(int mode);
    void EnableDisableCompass(int mode);
    void ResetMultiReferenceVectorsToZero();
    void SetMultiReferenceResolution(int mode);
    void SetCompassMultiReferenceVector(int Index,float Vector[3]);
    void SetCompassMultiReferenceCheckVector(int Index,float Vector[3]);
    void SetAccelMultiReferenceVector(int Index,float Vector[3]);
    void SetAccelMultiReferenceCheckVector(int Index,float Vector[3]);
    void SetAxisDirections(int direction);
    void SetRunningAveragePercent(float Percent);
    void SetCompassReferenceVector(float Vector[3]);
    void SetAccelerometerReferenceVector(float Vector[3]);
    void ResetKalmanFilter();
    void SetAccelerometerRange(int Accelrange);
    void SetMultiReferenceWeightPower(float WeightPower);
    void EnableDisableFilter(int Mode);
    void SetRunningAverageMode(int Mode);
    void SetGyroscopeRange(int mode);
    void SetCompassRange(int mode);
/**********************************************************************************************************************/    
    /*4.3.6 Commands for Reading Filter Parameters
    These commands allow the reading of parameters associated with the Kalman filter. All these commands return data,
    and accept no parameters.
    */
/**********************************************************************************************************************/    
    void ReadTareOrientationQuaternion(float *Quaternion);
    void ReadTareOrientationRotationMatrix(float *RotationMatrix);
    void ReadRhoDataAccelerometer(int *Rhomode,float *minroh,float *maxroh);
    void ReadRhoDataCompass(int *Rhomode,float *minroh,float *maxroh);
    void ReadCurrentUpdateRate(int *rate);
    void ReadCompassReferenceVector(float *Vector);
    void ReadAccelerometerReferenceVector(float *Vector);
    void ReadReferenceVectorMode(int *Mode);
    void ReadCompassMultiReferenceVector(int Index,float *Vector);
    void ReadCompassMultiReferenceCheckVector(int Index,float *Vector);
    void ReadAccelMultiReferenceVector(int Index,float *Vector);
    void ReadAccelMultiReferenceCheckVector(int Index,float *Vector);
    void ReadGyroEnabledState(int *Mode);
    void ReadAccelerometerEnabledState(int *Mode);
    void ReadCompassEnabledState(int *Mode);
    void ReadAxisDirections(int *direction);
    void ReadOversampleRate(int *Rate);
    void ReadRunningAveragePercent(float *Percent);
    void ReadDesiredUpdateRate(float *rate);
    void ReadKalmanFilterCovarianceMatrix(float *CovarianceMatrix);
    void ReadAccelerometerRange(int *Accelrange);
    void ReadMultiReferenceWeightPower(float *WeightPower);
    void ReadMultiReferenceResolution(int *Resolution);
    void ReadNumberOfmultiReferenceCells(int *NumberOfCells);
    void ReadFilterEnableState(int *Mode);
    void ReadRunningAverageMode(int *Mode);
    void ReadGyroscopeRange(int *mode);
    void ReadCompassRange(int *mode);
/**********************************************************************************************************************/    
    /*4.3.7 Commands for Calibration
    These commands allow the configuration and reading of calibration parameters and enabling of calibration modes.
    */
/**********************************************************************************************************************/    
    void SetCompassCalibrationParameters(float Bias[3],float Matrix[9]);
    void SetAccelerometerCalibrationParameters(float Bias[3],float Matrix[9]);
    void ReadCompassCalibrationParameters(float *Bias,float *Matrix);
    void ReadAccelerometerCalibrationParameters(float *Bias,float *Matrix);
    void ReadGyroCalibrationParameters(float *Bias, float *range);
    void BeginGyroAutocalibration();
    void SetGyroCalibrationParameters(float Bias[3], float range[3]);
/**********************************************************************************************************************/    
    /*4.3.8 General Commands
    These commands are for the configuration of the sensor as a whole as opposed to configuration of the filter or sensors.
    */
/**********************************************************************************************************************/    
    void ReadSoftwareVersion(char *version);
    void RestoreFactorySettings();
    void CommitSettings();
    void SoftwareReset();
    void EnableWatchdogTimer(int timer);
    void DisableWatchdogTimer();
    void EnterFirmwareUpdateMode();
    void ReadHardwareVersion(char *version);
    void SetUARTBaudRate(int Baudrate);
    void GetUARTBaudRate(int *Baudrate);
    void SetUSBmode(int mode);
    void GetUSBmode(int *mode);
    void SetClockSpeed(int clock);
    void GetClockSpeed(int *clock);
    void GetSerialnumber(int *serialnum);
    void SetLEDColor(float color[3]);
    void GetLEDColor(float *color);
    void EnableDisableJoystick(int Mode); 
    void EnableDisablemouse(int Mode);
    void ReadJoystickEnabledState(int *Mode);
    void ReadMouseEnabledState(int *Mode);
    void SetControlMode(float Controlclass,float controlindex,float handlerindex);
    void SetControlData(float Controlclass,float controlindex,float datapointindex,float datapoint );  
    void ReadControlMode(float *Handlerindex, float Controlclass,float controlindex);
    void ReadControlData(float *Datapoint,float ControlClass,float controlIndex,float dataPointIndex);
    void SetMouseAbsoluteRelative(int Mode);
    void ReadMouseAbsoluteRelative(int *Mode);
    void SetjoystickAndMousePresentRemoved(int Mode);
    void ReadjoystickAndMousePresentRemoved(int *Mode);
/**********************************************************************************************************************/    
/*
 clases needed to interface with the sensor
 */
/**********************************************************************************************************************/    
    
    
    private:
    Serial _SpaceSensor;
    char *st;
    float *vecf;
    char var[10];
    void begin(long baud);
    void read_string(float *vector,char *c);
    };
    
#endif