//Includes//
#ifndef _QuadCopter_H
#define _QuadCopter_H
#ifndef _MBED_H
#define _MBED_H
#include "mbed.h"
#endif
#ifndef _IOSTREAM_
#define _IOSTREAM_
#include "iostream"
#endif
#ifndef _MATH_H
#define _MATH_H
#define D_BAUDRATE            115200
//#include "math.h"
#endif
class PIDTheta{
    public:
    PIDTheta( PinName pwm,PinName pwm2,float Listen_time_ms,float KP,float KI,float KD,float KDD);//constructor
    void Motor_init(float Listen_time_ms);//initialization motors
    void Motor_Control_signal();//giving control signal to the motor.

    void PWM_cal(float RPM_req,float RPM_curr,float req_power_SP);//calculating the PWM taking in mind upper/lower limits and error calculation/estimation.
    void Set_OUT_Limits(float LowerLimit,float UpperLimit);//setting Output Limits.
    void Set_IN_Limits(float LowerLimit,float UpperLimit);//setting Input Limits.
    void Check_OUT_Limits(float *RPMSetPoint);//checking Input Limits in the Realtime operation.
    void Check_IN_Limits(float *O_PWM);//checking Output Limits in Realtime operation.
    
    private:
    void Pulse_Error_cal(float RPM_req,float RPM_curr);//error calculating and out the relative output to the relative error.
    //variables and PinRoles
    float PowerSetPoint;//,RPMSetPoint;
    float Out_PWM,Out_PWM2;
    float O_Upper_Limit,O_Lower_Limit;
    float I_Upper_Limit,I_Lower_Limit;
    float Error,ErrorI,ErrorD,ErrorOLD,ErrorDD,ErrorDOLD;
    float h;
    float _KP,_KD,_KI,_KDD;
    //Serial debugSerial;
    PwmOut _pwm;
    PwmOut _pwm2;
};

#endif