//INCLUDES
#include "Pushbutton.h"

#define timer_read_s(x)     chrono::duration_cast<chrono::seconds>((x).elapsed_time()).count()

DigitalIn Pushbutton::lastPressed(PIN_ACCEL_PANEL);

//Constructor
Pushbutton::Pushbutton(PinName bt) : button(bt),buttonInt(bt),button2(bt){}
Pushbutton::Pushbutton(PinName bt, int* state, int* flagIn, PinName bt2) : buttonInt(bt),button(bt),button2(bt2){
    flag = flagIn;
    mode = state;
    if(INPUT_LOGIC == 0)
    {
        buttonInt.fall(callback(this,&Pushbutton::updateMode));
    }
    else
    {
        buttonInt.rise(callback(this,&Pushbutton::updateMode));
    }
}

//Methods
//read()
int Pushbutton::read(){
    if(Pushbutton::lastPressed == INPUT_LOGIC && Pushbutton::lastPressed != button)
        return 0;
    else if(Pushbutton::lastPressed == INPUT_LOGIC && Pushbutton::lastPressed == button)
        return 1;
    
    wait_us(DEBOUNCE_TIME);
    
    Pushbutton::lastPressed = (button == INPUT_LOGIC) ? button : Pushbutton::lastPressed;
    return (button == INPUT_LOGIC) ? 1 : 0;
}

//setConnected()
void Pushbutton::setConnected(bool con){
    connected = con;
}

//updateMode()
void Pushbutton::updateMode()
{   
    Timer t;
    t.start();
    
    wait_us(DEBOUNCE_TIME);
    if(read()) //If received input
    {
        *flag = 1;
        while((int)timer_read_s(t) <= TIME_WSETTING) //check if button is held to the threshold
        {
            if(buttonInt.read() != INPUT_LOGIC) //check if button is released
            {
                if(*mode == OP_NORMAL || *mode == OP_WIND)
                {
                    *mode = OP_MANUAL1;
                    return;
                }
                else if(*mode == OP_MANUAL1)
                {
                    *mode = OP_MANUAL2;
                    return;
                }
                else if(*mode == OP_MANUAL2)
                {
                    *mode = OP_MANUAL_ALL;
                    return;
                }
                else if(*mode == OP_MANUAL_ALL || *mode == OP_WSETTING || *mode == OP_CONFIRM || *mode == OP_POWER_OFF || *mode == OP_ATRACK ||*mode == OP_RECONNECT)
                {
                    *mode = OP_NORMAL;
                    return;
                }
                else if(*mode == OP_PLACEMENT){
                    *mode = OP_CONFIRM;
                    return;
                }
                else if(*mode == OP_OVERHEAT){
                    return;
                }
                else if(*mode == OP_OVERHEAT_MAN){
                    *mode = OP_OVERHEAT;
                    return;
                }
                else if(*mode == OP_ETHERNET){
                    *mode = OP_ETHERNET;
                }
                else{
                    *mode = OP_PLACEMENT;
                    return;
                }
                t.stop();
                return;
            }
        }
        
        if(button2.read() && connected)
            *mode = OP_ATRACK;
        else if(button2.read() && !connected)
            *mode = OP_RECONNECT;
        else
            *mode = OP_WSETTING;
        return;
    }
}
