#include "mbed.h"
#include "LCD.h"
#include <string>

//Code for Newhaven NHD‐0216K3Z‐FL‐GBW LCD interfaced to FRDM-K64F via I2C
LCD::LCD(I2C* i2cIn){
    i2c = i2cIn;
    LCD_init();
    clearLCD();
    wait_us(LCD_DELAY); //wait for stabilization
}

void LCD::LCD_init(void) {
    
    //LCD Initiations---------------------------------------
    char cmd[3]; 
  
    cmd[0] = 0xFE; //For all cases
    cmd[1] = 0x52;
    cmd[2] = 40;        //contrast 1 - 50 
    i2c->write(addr, cmd, 3);
    
    cmd[1] = 0x53;
    cmd[2] = 8;        //Backlight 1-8
    i2c->write(addr, cmd, 3);
           
    cmd[1] = 0x48;
    i2c->write(addr, cmd, 2); //Underline cursor off
    
    cmd[1] = 0x46;
    i2c->write(addr, cmd, 2); //Cursor Home 
    
} //END LCD_init


void LCD::clearLCD(void) {
    
    char cmd[3];
    cmd[0] = 0xFE;
    wait_us(100);
    
    cmd[1] = 0x51;
    i2c->write(addr, cmd, 2); //clear current display 
    
    cmd[1] = 0x46;
    i2c->write(addr, cmd, 2); //Cursor Home 
     
} //END clearLCD


void LCD::LCD_display(string topLine, string bottomLine) {
    
    int i;
    
    char cmd[16]; //Long enough to send a complete line of text
    for(i = 0; i < 16; i++)
        cmd[i] = ' ';


    clearLCD(); //Clear before display

    wait_us(LCD_DELAY); //Short Delay 
  
    for(i=0;i < topLine.length();i++) { //Display top line
        cmd[i]=topLine[i];
    }
    i2c->write(addr,cmd,16);
       
    cmd[0] = 0xFE; //Since it was overwritten above    
    cmd[1] = 0x45;
    cmd[2] = 0x40;        //LCD Cursor to next line 
    i2c->write(addr, cmd, 3);
       
    wait_us(LCD_DELAY); //Delay between writing lines
    
    for(i = 0; i < 16; i++)
        cmd[i] = ' ';
    for(i=0;i < bottomLine.length();i++) { //Display bottom line
        cmd[i]=bottomLine[i];
    }
    i2c->write(addr,cmd,16);  
    cmd[0] = 0xFE; //Since it was overwritten above  
   
 } //END LCD_display  

 
     
 
     
 
