#ifndef DEFS_SETT_H
#define DEFS_SETT_H

//INVERTER SETTINGS
#define MAX_POWER               330             //Max power of the inverter (W)
#define THRESHOLD_PER           0.95            //The fraction of power where the system should halt

//HARDWARE SETTINGS
#define DEBOUNCE_TIME           10000           //Debounce time for pushbutton (us)
#define INPUT_LOGIC             1               //0 - Active Low, 1 - Active High
#define LOOP_DELAY              2000           //Delay for main loop (us)
#define VCC                     3.3             //VCC of K64F board

//CONNECTION SETTINGS
#define URL                     "int-sol-ref.herokuapp.com"
#define PORT                    80
#define CONN_N                  5               //Times for trying reconnection
#define TIME_RECON              300             //Time for checking to reconnect
#define TIME_GUIWIND            1000            //Time for sending windspeed to the server

//BEHAVIORIAL SETTINGS
#define TIME_NORMAL             10              //Time Between Adjustment in Normal Mode (seconds)
#define TIME_WSETTING           1               //Time FN button need to be held for the system to go to WSETTING mode (seconds)
#define TIME_MANUAL_TIMEOUT     3600            //Time for the system to resume NORMAL mode after idling in MANUAL mode (seconds)
#define TIME_WSETTING_TIMEOUT   3               //Time for the system to resume NORMAL mode after idling in WSETTING mode (seconds)
#define TIME_RECONNECT_TIMEOUT  1000000         //Time for reconnect mode to timeout (us)
#define TIME_ATRACK_TIMEOUT     1000000         //Time for auto tracking display to timeout (us)
#define TICK_WIND               1000ms          //Interval for Checking Wind Speed

//PHYSICAL ATTRIBUTES
#define PANEL_HEIGHT            0.8255          //Heigh of Panels' Pivot
#define REFLECTOR1_HEIGHT       0.0889          //Height of Reflector 1 Pivot
#define REFLECTOR2_HEIGHT       0.0889          //Height of Reflector 2 Pivot
#define REFLECTOR1_LENGTH       1.0             //Length of Reflector 1
#define REFLECTOR2_LENGTH       1.0             //Length of Reflector 2
#define REFLECTOR1_DIST         0.7747          //Distance Between Panel's Pivot and Reflector 1 Pivot
#define REFLECTOR2_DIST         0.7874          //Distance Between Panel's Pivot and Reflector 2 Pivot
#define REFLECTOR1_LOW          0.0             //Lower Limit of Reflector 1 Range of Motion
#define REFLECTOR2_LOW          0.0             //Lower Limit of Reflector 1 Range of Motion
#define REFLECTOR1_HIGH         70              //Upper Limit of Reflector 2 Range of Motion
#define REFLECTOR2_HIGH         70              //Upper Limit of Reflector 2 Range of Motion

//ALGORITHM SETTINGS
#define LOOP_LIMIT              1000            //Max Loop Iterration
#define ERR_LIMIT               0.01            //Secant Error Limit

//ACCELEROMETER SETTINGS
#define ANGLE_TOL               2               //Angle Tolerance (Degrees)
#define N_AVG                   60              //Averaging
#define N_CAL                   150             //Calibration sampling
#define MEAS_AXIS               2               //Measurement Axis (0 - Z, 1 - Y, 2 - X)
#define MUL_P                   1.0             //Multiplier of panel accelerometer
#define MUL_R1                  1.0             //Multiplier of reflector 1 accelerometer
#define MUL_R2                  1.0             //Multiplier of reflector 2 accelerometer

//ANEMOMETER SETTINGS
#define WIND_THRES_INIT         10              //Default safety windspeed (km/h)
#define WIND_THRES_MIN          10              //Minimum safety windspeed setting (km/h)
#define WIND_THRES_MAX          100             //Maximum safety windspeed setting (km/h)
#define WIND_AVG                15              //Averaging
#define WIND_HYST               2               //Wind hysteresis
#define WIND_INC                5               //Wind mode increment

//LCD SETTING
#define LCD_INIT_DELAY          100000          //LCD initialization delay
#define LCD_DELAY               1000            //Delay for printing characters (us)
#define LCD_RRATE               1000            //LCD refresh rate (ms)

//TEMPERATURE CONTROL
#define TEMP_LOW                15.0            //Low temperature limit
#define TEMP_HIGH               75.0            //High temperature limit
#define TEMP_HYST               5.0             //Temperature hysteresis
#define TEMP_PERIOD             40.0f           //Fan period (ms)
#define TEMP_AVG                10              //Number of averaging
#define TEMP_DELAY              10000           //Delay between reading (us)
#define TEMP_PWM_LOW            0.13            //Low limit of PWM
#define TEMP_PWM_HIGH           1.0             //High limit of PWM

//I2C SETTING
#define I2C_FREQ                50000           //I2C Frequency (Hz)

//MODES AND SOURCES
//Operations
#define OP_CALIBRATION          0
#define OP_NORMAL               1
#define OP_WIND                 2
#define OP_MANUAL1              3
#define OP_MANUAL2              4
#define OP_WSETTING             5
#define OP_PLACEMENT            6
#define OP_CONFIRM              7
#define OP_MANUAL_ALL           8
#define OP_OVERHEAT             9
#define OP_OVERHEAT_MAN         10
#define OP_POWER_OFF            11
#define OP_ATRACK               12
#define OP_RECONNECT            13
#define OP_ETHERNET             14
//Accelerometer Selection
#define S_PANEL                 0
#define S_R1                    1
#define S_R2                    2
//Motor Selection
#define M1                      1
#define M2                      2
#define M_ALL                   3
#endif