//INCLUDES
#include "Anemometer.h"

//Constructor
Anemometer::Anemometer() : ane(PIN_ANEMOMETER) 
{
    wthres = WIND_THRES_INIT;
}

//getWind
float Anemometer::getWind(int* flag)
{
    float spd;
    spd = 72.9*ane*VCC-29.16;
    *flag = 1;
    return (spd < 0)? 0:spd;
}

//getWind
float Anemometer::getWind()
{
    float spd;
    spd = 72.9*ane*VCC-29.16;
    return (spd < 0)? 0:spd;
}

//setThres
void Anemometer::setThres(int thres)
{
    wthres = thres;
}

//checkWind
void Anemometer::checkWind(int* mode)
{
    if(Anemometer::getWind() >= wthres)
        *mode = OP_WIND;
    else if(Anemometer::getWind() < wthres - WIND_HYST)
        *mode = OP_NORMAL;
}