#ifndef ACCELEROMETER_H
#define ACCELEROMETER_H

//INCLUDES
#include "mbed.h"
#include "MPU6050.h"
#include "Defs_Sett.h"
#include "algorithm"

class Accelerometer
{
    public:
    //Constructor
    Accelerometer(I2C *i2cIn);
    
    //Functions
    bool checkConnection(); //Check if the accelerometer is connected
    float getAngleCal(int s,int n); //Get angle for callibration
    float getAngle(int s); //Reading angle from specified axis
    bool checkAngle(float ref, float cur); //Check if angle is within target range
    void calibrate(); //Calibrate zero offset
    
    private:
    DigitalOut Panel;
    DigitalOut R1;
    DigitalOut R2;
    MPU6050 acc;
    float AOffset[3],curOffset,mul;
    
    void setSource(int n); //Switch between accelerometers
};

#endif