#include "mbed.h"
#include "adc.h"
#include "MCP23S17.h"
#include "rtos.h"
#define MN 256 
#define SAMPLE_RATE   48000

// Create SPI bus
SPI spi(p5, p6, p7);

DigitalOut layer0(p24);
DigitalOut layer1(p23);
DigitalOut layer2(p22);
DigitalOut layer3(p21);
AnalogIn ain(p18);

char Opcode = 0x40;
MCP23S17 chip = MCP23S17(spi, p20, Opcode);
Timer timer;
Ticker ticker;

int Counter = 0;
int led_control = 1;
int16_t Buffer[5000];
unsigned char PowerInt[MN/2];
ADC adc(SAMPLE_RATE, 1);
float g;

void sample_ADC(int chan, uint32_t value) {
    float s;
    s = adc.read(p19);
    Counter += 1;
    g = abs(s-2048);
    g = g/2048;   
}

void LED_Thread(void const *args) {
    chip.write(PORT_A, 0x00);
    chip.write(PORT_B, 0x00);
    layer0 = 1;
    layer1 = 0;
    layer2 = 0;
    layer3 = 0;
//  Set all 8 Port A bits to output direction
    chip.direction(PORT_A, 0x00);
//  Set all 8 Port B bits to output direction
    chip.direction(PORT_B, 0x00);
    unsigned char c[] = {0x01, 0x02, 0x04, 0x08, 0x10, 0x20, 0x40, 0x80};
    while(1){
        switch(led_control){
            case 0: //Standard Mode
                chip.write(PORT_A, 0xFF);
                chip.write(PORT_B, 0xFF);
                if(g > 0 && g < .25){
                    layer3 = 1;
                }else{
                    layer3 = 0;   
                }    
                if(g > .25 && g < .5){
                    layer2 = 1;
                }else{
                    layer2 = 0;   
                }    
                if(g > .5 && g < .75){
                    layer1 = 1;
                }else{
                    layer1 = 0;   
                }    
                if(g > .75 && g < 1){
                    layer0 = 1;
                }else{
                    layer0 = 0;   
                } 
                break;
            case 1: //Standard + Screensaver
                char c_rand[] = {0x01, 0x02, 0x04, 0x08, 0x10, 0x20, 0x40, 0x80};
                if(g > 0 && g < .25){
                    layer3 = 1;
                }else{
                    layer3 = 0;   
                }    
                if(g > .25 && g < .5){
                    layer2 = 1;
                }else{
                    layer2 = 0;   
                }    
                if(g > .5 && g < .75){
                    layer1 = 1;
                }else{
                    layer1 = 0;   
                }    
                if(g > .75 && g < 1){
                    layer0 = 1;
                }else{
                    layer0 = 0;   
                } 
                for( int i = 0; i <=7; i++){chip.write(PORT_A, c[i]); //A loop
                Thread::wait(10);}
                chip.write(PORT_A, 0x00);
                for( int i = 0; i <=7; i++){chip.write(PORT_B, c[i]); //A loop
                Thread::wait(10);}
                chip.write(PORT_B, 0x00); //CLEAR
                break;
            case 2: //Standard + Screensaver {{RANDOM}}
                char c_rand[] = {0x01, 0x02, 0x04, 0x08, 0x10, 0x20, 0x40, 0x80};
                if(g > 0 && g < .25){
                    layer3 = 1;
                }else{
                    layer3 = 0;   
                }    
                if(g > .25 && g < .5){
                    layer2 = 1;
                }else{
                    layer2 = 0;   
                }    
                if(g > .5 && g < .75){
                    layer1 = 1;
                }else{
                    layer1 = 0;   
                }    
                if(g > .75 && g < 1){
                    layer0 = 1;
                }else{
                    layer0 = 0;   
                } 
                for (int i=0; i<7; i++) {
                    int r = rand() % 7;  // generate a random position
                    int temp = c_rand[i]; c_rand[i] = c_rand[r]; c_rand[r] = temp;
                }
                for( int i = 0; i <=7; i++){chip.write(PORT_A, c_rand[i]); //A loop
                Thread::wait(10);}
                chip.write(PORT_A, 0x00);
                for( int i = 0; i <=7; i++){chip.write(PORT_B, c_rand[i]); //A loop
                Thread::wait(10);}
                chip.write(PORT_B, 0x00); //CLEAR
                break;
            case 3: //Screensaver
                for(int n = 0; n<= 3; n++){
                    switch(n){
                        case 1: layer0 = 0; layer1 = 1; layer2 = 0; layer3 = 0;
                            break;
                        case 2: layer0 = 0; layer1 = 0; layer2 = 1; layer3 = 0;
                            break;
                        case 3: layer0 = 0; layer1 = 0; layer2 = 0; layer3 = 1;
                            break;
                        default: layer0 = 1; layer1 = 0; layer2 = 0; layer3 = 0;
                            break;
                    }
                for( int i = 0; i <=7; i++){chip.write(PORT_A, c[i]); //A loop
                Thread::wait(100);}
                chip.write(PORT_A, 0x00);
                for( int i = 0; i <=7; i++){chip.write(PORT_B, c[i]); //A loop
                Thread::wait(100);}
                chip.write(PORT_B, 0x00); //CLEAR
                }
                break;
        }
    Thread::wait(25);    
    }
}    

int main() {
    Thread t1(LED_Thread);
    while (1) {
        //Prepare for burst mode on all ADC pins and set up interrupt handler
        adc.append(sample_ADC);
        adc.startmode(0,0);
        adc.burst(1);
        adc.setup(p19,1);
        wait(.4);
        adc.interrupt_state(p19,1);
        wait(0.1);
        adc.interrupt_state(p19,0);
        adc.setup(p19,0);
        int actual_rate = adc.actual_sample_rate();
    }
}





