#include <stdio.h>
#include "mbed.h"
#include "Si7020.h"

I2C i2c(I2C_SDA, I2C_SCL);
Si7020 si(&i2c);

int main()
{
    while(1) {

        float humid;
        if(si.getHumidity(&humid) != 0) {
            printf("Error getting humidity\n");
            humid = -1;
        }

        float temp;
        if(si.getTemperature(&temp) != 0) {
            printf("Error getting temperature");
            temp = -1;
        } 
        printf("Humidity = %f%% Temperature = %fC\n", humid, temp);

        wait(1);
    }
}