#include "Stepper.h"
#include "mbed.h"

stepper::stepper(PinName _en, PinName _stepPin, PinName dir):en(_en),
    stepPin(_stepPin),
    direction(dir)
{
}

void stepper::step(float tspeed){
    
    float speed;
    //max acceleration limiting
    if ((actualSpeed - tspeed) > MAX_ACCEL)
        speed = actualSpeed - MAX_ACCEL;
    else if ((actualSpeed - tspeed) < -MAX_ACCEL)
        speed = actualSpeed + MAX_ACCEL;
    else
        speed = tspeed;

    if (speed == 0) {
        toggler.detach();
    }
    else if(speed >0) {
        direction = 0;
        toggler.attach_us(this,&stepper::toggle_step,1000000/abs(speed)); 
    }
    else{
        direction = 1;
        toggler.attach_us(this,&stepper::toggle_step,1000000/abs(speed)); 
    }
    actualSpeed = speed; 
}

void stepper::enable(){
    en = 0;
}

void stepper::disable(){
    en = 1;
}

void stepper::toggle_step (){
    stepPin = !stepPin; 
}