#include "mbed.h"
#include "SakuraIO.h"

#define     SAKURAIO_SDA      PC_9
#define     SAKURAIO_SCL      PA_8
#define     SAKURAIO_PIN_RST  PC_6
#define     SAKURAIO_PIN_WKIN PC_7

Serial        pc(USBTX, USBRX);
SakuraIO_I2C  sakuraio(SAKURAIO_SDA, SAKURAIO_SCL);
DigitalInOut  sakuraIoReset(SAKURAIO_PIN_RST, PIN_OUTPUT, OpenDrain, 1);
DigitalInOut  sakuraIoWakeIn(SAKURAIO_PIN_WKIN, PIN_INPUT, PullUp, 1);

int main()
{
    wait(5);
    pc.printf("waiting for connection .");
    int status;
    do {
        status = sakuraio.getConnectionStatus();
        pc.printf(".");
        wait(1);
    } while (status != 0x80);

    pc.printf(" connected\r\n");
    pc.printf("updating firmware ");

    // prepare for firmware update
    sakuraio.unlock();

    switch (status = sakuraio.updateFirmware()) {
        case 0x01:
            pc.printf("start ");
            break;
        case 0x02:
            error("parity error\r\n");
            break;
        case 0x03:
            error("unsupported request\r\n");
            break;
        case 0x04:
            error("argument error\r\n");
            break;
        case 0x05:
            error("result error\r\n");
            break;
    }

    while(1) {
        status = sakuraio.getFirmwareUpdateStatus();
        pc.printf("update status=%d\r\n", status);
        bool running = status & (1 << 7);
        bool error = status & (1 << 6);
        int errCode = status & 0b00111111;

        if (running) {
            pc.printf(".");

            wait(1);
            continue;
        } else {
            switch (errCode) {
                case 0x00:
                    pc.printf("firmware update succeeded.\r\n");
                    break;
                case 0x01:
                    pc.printf("firmware already updated.\r\n");
                    break;
                case 0x02:
                    pc.printf("failed to download latest firmware\r\n");
                    break;
                case 0x03:
                    pc.printf("failed to download firmware\r\n");
                    break;
                case 0x04:
                    pc.printf("firmware verify failed\r\n");
                    break;
            }
            break;
        }
    }
}
