/*-------------------------------------------------------------------------------------------------------------
Program Name:   SDGlobals.h
Version:        1.x
Sprache:        C++
Compiler:       mbed
Autors:         UFa/PS

Funktion:       Globale Variablen für die SD-Card Zugriffe

Modified: 
2018-02-02 UFa: Initiale Erstellung
 
 --------------------------------------------------------------------------------------------------------------*/

// #define UF_EQUAL            "="
#define BLANK               " "

#define FILE_RW_BUF_LEN     512



// Strukturen -------------------------------------
/*===========================================================================
Die nachfolgende Struktur dient zur Bearbeitung der SD-Card
===========================================================================*/
struct strSdCard
{
    int  MWString;
//     char MethInfo[4];

    char SeqFileName[128];   
    char GenFile[128];  // wird für Sequenzmessung genommen

};
typedef struct strSdCard STR_SD_CARD;


/*===========================================================================
Die nachfolgende Struktur dient zur Speicherung der Dateinamen
===========================================================================*/
struct strFileNames
{
	char IniFileName[32];
	char DevIdFileName[32];
	char ParaFileName[32];
	char ConfigFileName[32];
	char DataPathName[32];
	char SeqPathName[32];
    char AutoFileName[32];  // Datei mit den Variablen fuer den Autostart
	char FileReadMode[4];
	char FileWriteMode[4];
	char FileAppendMode[4];

};
typedef struct strFileNames STR_FILE_NAMES;





// Variablen-------------------------------------

extern class StorageCard clSdCard;
extern STR_SD_CARD SdCard;  // Variablen Struktur fuer die SdCard
extern STR_FILE_NAMES FileNames;

extern bool g_SdInitSuccess;  // Fehler bei der Initialisierung der SD Karte, möglicherweise nicht gesteckt. 
extern char strFileRwBuf[512]; // Lese und Schreibpuffer für Dateizugriffe



// Funktionen -------------------------------------
extern int InitSdFileSystem();
extern int CheckDiscStatus();
extern void InitclSdCard();
extern void InitFileNames();

