/*-------------------------------------------------------------------------------------------------------------
Program Name:   SDGlobals.cpp
Version:        1.x
Sprache:        C++
Compiler:       mbed
Autors:         UFa/PS

Funktion:       Globale Variablen für die SD-Card Zugriffe

Modified: 
17.04.16 PS: entfernen der Stringklassen
 
 --------------------------------------------------------------------------------------------------------------*/
 
#include "mbed.h"

#include <stdio.h>
#include <algorithm>

#include "SdGlobals.h"
#include "SdCard.h"

#include "SDBlockDevice.h"
#include "FATFileSystem.h"

// Globale Variablen und Klassen

//SDFileSystem sd_x(PTE3, PTE1, PTE2, PTE4, "sd"); // MOSI, MISO, SCK, CS
SDBlockDevice bd(
        MBED_CONF_SD_SPI_MOSI,
        MBED_CONF_SD_SPI_MISO,
        MBED_CONF_SD_SPI_CLK,
        MBED_CONF_SD_SPI_CS);
        
FATFileSystem fs("SDCard");        

STR_FILE_NAMES FileNames;

StorageCard clSdCard;
STR_SD_CARD SdCard;  // Variablen Struktur fuer die SdCard

char strFileRwBuf[512];


bool g_SdInitSuccess;


// Funktionen
    
/*-------------------------------------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------------------------------------
Initialisieren der SD-FileSystem Klasse. 
---------------------------------------------------------------------------------------------------------*/
int InitSdFileSystem()
{
    int FReturn;
    
    FReturn = false;
	InitFileNames();
    
    //   OLD  MySd = new SDFileSystem(PTE3, PTE1, PTE2, PTE4, "SDCard"); // MOSI, MISO, SCK, CS
    //   OLD  MySd->disk_initialize();

    g_SdInitSuccess = true;
    if(g_SdInitSuccess == true)
    {
        // OLD Ret = CheckDiscStatus();
        FReturn = true;
    }
    
    InitclSdCard();
    bd.init();
    fs.mount(&bd);
    return(FReturn);
}
/*--------------------------------------------------------------------------------------------------------
InitFileNames: Zeichenfelder mit Dateinamen und Pfaden vorbelegen
---------------------------------------------------------------------------------------------------------*/
void InitFileNames()
{
	strcpy(FileNames.IniFileName,  "/SDCard/ecmini.CFG");
	strcpy(FileNames.DevIdFileName,"/SDCard/DevIni.cfg");
	strcpy(FileNames.ParaFileName, "/SDCard/cfg/parameters.CFG");
	strcpy(FileNames.ConfigFileName,"/SDCard/cfg/config.CFG");
	strcpy(FileNames.DataPathName,"/SDCard/data/");
	strcpy(FileNames.SeqPathName,"/SDCard/scandat/");
	strcpy(FileNames.FileReadMode,"r+");
	strcpy(FileNames.FileWriteMode,"w+");
	strcpy(FileNames.FileAppendMode,"a");
	
	strcpy(FileNames.AutoFileName,"/SDCard/autostart.CFG"); 
}
/*--------------------------------------------------------------------------------------------------------
Initialisieren der SD-Card. Das Anlegen der 
---------------------------------------------------------------------------------------------------------*/
int CheckDiscStatus()
{
    // OLD return(MySd->disk_status());
    return(true);
}

/*--------------------------------------------------------------------------------------------------------
Initialisieren der eigenen SD-Card Klasse. 
---------------------------------------------------------------------------------------------------------*/
void InitclSdCard()
{
    clSdCard.Init();
}


