/*-------------------------------------------------------------------------------------------------------------
Program Name:   SDCard.cpp
Version:        1.x
Sprache:        C++
Compiler:       mbed
Autors:         UFa/PS

Funktion:       Lesen und Schreiben der SD-Card

History: 
30.09.2019: 
Vorsicht, es gibt zwei Dateien zum Autospeichern. Die Datei autostart.CFG, welche die Konfigurationsdaten
zum Handling der Autostart Messfunktion aufnimmt und die Datei(en) MW_AUTO%d, welche die Messwerte aufnimmt und 
durchnummeriert wird. Folgende Variablen und Methoden liegen dem zugrunde:
autostart.cnf: 
FileNames.AutoFileName,"/SDCard/autostart.CFG"
clSdCard.OpenAutoFile(FileNames.AutoFileName, FileNames.FileReadMode);
clSdCard.ReadAutoLine(strFileRwBuf, FILE_RW_BUF_LEN);
clSdCard.WriteAutoLine(); schreibt den Puffer clSdCard.cSdLine
clSdCard.CloseAutoFile();


Messdateien:
AutoStart.MwFileName, "/SDCard/data/MW_AUTO_%d.ASC"
clSdCard.OpenMwAutoFile(AutoStart.MwFileName, FileNames.FileWriteMode);
clSdCard.WriteMwAutoLine();  schreibt den Puffer strFileRwBuf


 --------------------------------------------------------------------------------------------------------------*/

#include "Headers.h"




/*-----------------------------------------------------------------------------------------------
Init: Initialisieren der Startwerte
-----------------------------------------------------------------------------------------------*/
int StorageCard::Init() 
{
   m_fFileIsOpen = false;
   m_fHeaderIsOpen = false;
   m_Fp = NULL;
   m_FpHeader = NULL;
   m_FpAutoFile = NULL;
   m_fAutoFileIsOpen = false;
   m_FpMwAutoFile = NULL;
   m_fMwAutoFileIsOpen = false;
   return(true);   
}
/*-----------------------------------------------------------------------------------------------
OpenFile: Öffnet eine Datei über den Namen der im Aufrufparameter enthalten ist
Returnwert ist true bei erfolgreichem Öffnen
Returnwert ist false bei fehlerhaftem Öffnen
-----------------------------------------------------------------------------------------------*/
int StorageCard::OpenFile(char *FName, char *OpenMode) 
{
    if(m_fFileIsOpen == true)       // eine andere Datei ist geöffnet. Sollte eigentlich nicht vorkommen, 
    {
		sprintf(HostIf.strErrorBuf,"%c#ER#Error open file %s, another file is opened.  %c\r\n", STX, FName, ETX); // 
		if(g_fOnDuringInit)
			printf("%s",HostIf.strErrorBuf); 
		else
			HostIf.fSendError = true;
	    return(false);              // ist nur zur Sicherheit
    }        
   	m_Fp = fopen(FName, OpenMode);   //  Datei im OpenMode öffnen
   	if(m_Fp == NULL)    // Fehler beim Öffnen der Datei, der wesentliche Grund ist, das die Datei nicht vorhanden ist. 
                        // Die Konsequenz ist, daß die Quelldaten initialisiert werden müssen, eine Fehlermeldung muss nicht ausgegeben werden,
                        // es dürfen jedoch keine weiteren Daten aus der Datei gelesen werden. 
   {
		sprintf(HostIf.strErrorBuf,"%c#ER#File could not opened: %s %c\r\n", STX, FName, ETX); // 
		if(g_fOnDuringInit)
			printf("%s",HostIf.strErrorBuf); 
		else
			HostIf.fSendError = true;
        return(false);
   }
   m_fFileIsOpen = true;
   
   rewind(m_Fp);
   return(true);    
    
}
/*-----------------------------------------------------------------------------------------------
OpenFile: Öffnet eine Header-Datei über den Namen der im Aufrufparameter enthalten ist
Returnwert ist true bei erfolgreichem Öffnen
Returnwert ist false bei fehlerhaftem Öffnen
-----------------------------------------------------------------------------------------------*/
int StorageCard::OpenHeaderFile(char *FName, char *OpenMode) 
{
   if(m_fHeaderIsOpen == true)       // eine andere Datei ist geöffnet. Sollte eigentlich nicht vorkommen, 
    {
		sprintf(HostIf.strErrorBuf,"%c#ER#Error open file %s, another file is opened.  %c\r\n", STX, FName, ETX); // 
		if(g_fOnDuringInit)
			printf("%s",HostIf.strErrorBuf); 
		else
			HostIf.fSendError = true;
	    return(false);              // ist nur zur Sicherheit
    }        
        
   m_FpHeader = fopen(FName, OpenMode);   //  Datei im OpenMode öffnen
   if(m_FpHeader == NULL)    // Fehler beim Öffnen der Datei, der wesentliche Grund ist, das die Datei nicht vorhanden ist. 
                        // Die Konsequenz ist, daß die Quelldaten initialisiert werden müssen, eine Fehlermeldung muss nicht ausgegeben werden,
                        // es dürfen jedoch keine weiteren Daten aus der Datei gelesen werden. 
   {
		sprintf(HostIf.strErrorBuf,"%c#ER#Error open Header-File %s.  %c\r\n", STX, FName, ETX); // 
		HostIf.fSendError = true;
        return(false);
   }
   m_fHeaderIsOpen = true;
   
   rewind(m_FpHeader);
   return(true);    
}

/*-----------------------------------------------------------------------------------------------
CloseFile: Schließt eine geöffnete Datei
Returnwert ist true bei erfolgreichem Schliessen
Returnwert ist false bei fehlerhaftem Schliessen
-----------------------------------------------------------------------------------------------*/
int StorageCard::CloseHeaderFile() 
{
    if(m_fHeaderIsOpen == true)
    {
        clearerr(m_FpHeader);        
        fflush(m_FpHeader); 
        fclose(m_FpHeader);   //  Datei zu
        m_fHeaderIsOpen = false;
        m_FpHeader = NULL;
        return(true);  
    }
    return(false);  
}

/*-----------------------------------------------------------------------------------------------
ReadLine: Liest eine Zeile aus der geöffneten Datei 
Wenn der Pointer von fgets nach dem Leseversuch NULL ist, dann wurde nichts mehr gelesen 
und die Datei wird automatisch geschlossen, d.h. die lesende Funktion muss nur so lange lesen
bis false zurückkommt.  
-----------------------------------------------------------------------------------------------*/
int StorageCard::ReadLine(char *Dest, int MaxLen) 
{
   if(m_fFileIsOpen == true)
    {
        if(fgets(Dest , MaxLen , m_Fp) != NULL )
            return(strlen(Dest));
        clearerr(m_Fp);        
    }
   return(false);
}
/*-----------------------------------------------------------------------------------------------
WriteLine: Schreibt eine Zeile in die geöffneten Datei 
Wenn beim Schreiben ein Fehler auftrifft, dann wird false zurückgegeben, ansonsten true.
-----------------------------------------------------------------------------------------------*/
int StorageCard::WriteLine() 
{   
   if(m_fFileIsOpen == true)
   {
        fputs(cSdLine, m_Fp);
        if (ferror (m_Fp))
        {
            clearerr(m_Fp);        
            fclose(m_Fp);        
            m_fFileIsOpen = false;
            return(false);
        }
        fflush(m_Fp);
        return(true);
   }
  
   return(false);
}
/*-----------------------------------------------------------------------------------------------
WriteHeaderLine: Schreibt eine Zeile in die geöffneten Datei 
Wenn beim Schreiben ein Fehler auftrifft, dann wird false zurückgegeben, ansonsten true.
-----------------------------------------------------------------------------------------------*/
int StorageCard::WriteHeaderLine() 
{   
   if(m_fHeaderIsOpen == true)
   {
        fputs(strFileRwBuf, m_FpHeader);
        if (ferror (m_FpHeader))
        {
            clearerr(m_FpHeader);        
            fclose(m_FpHeader);        
            m_fHeaderIsOpen = false;
            return(false);
        }
        return(true);
   }
   return(false);
}

/*-----------------------------------------------------------------------------------------------
CloseFile: Schließt eine geöffnete Datei
Returnwert ist true bei erfolgreichem Schliessen
Returnwert ist false bei fehlerhaftem Schliessen
-----------------------------------------------------------------------------------------------*/
int StorageCard::CloseFile() 
{
    if(m_fFileIsOpen == true)
    {
        clearerr(m_Fp);        
        fflush(m_Fp); 
        fclose(m_Fp);   //  Datei zu
        m_fFileIsOpen = false;
        m_Fp = NULL;
#ifdef TFT_DEBUG
    printf("In CloseFile of SdCard \n");
#endif
        return(true);  
    }
    return(false);  
}
/*-----------------------------------------------------------------------------------------------
ReadFile: Lesen einer kompletten Datei über Klassenmethoden
-----------------------------------------------------------------------------------------------*/
int StorageCard::ReadFile(char *fName, char *DestBuf, int MaxLen)
{
    int Ret, Len;
    
    if(OpenFile(fName, FileNames.FileReadMode) == false)
        return(false);    
        
    Len = 0;
    do
    {
        Ret = ReadLine(strFileRwBuf, FILE_RW_BUF_LEN);
        if(Ret > 0) // es wurden Zeichen gelesen
        {
            Len += Ret;
            if(Len < MaxLen)
                strcat(DestBuf, strFileRwBuf);
        }
    }
    while(Ret > 0);
   
    CloseFile();
    return true;
   
}

/*-----------------------------------------------------------------------------------------------
WriteFile: Schreiben einer kompletten Datei über Klassenmethoden
-----------------------------------------------------------------------------------------------*/
int StorageCard::WriteFile(char *fName, char *SrcBuf)
{
    int Ret;
    
    if(OpenFile(fName, FileNames.FileWriteMode) == false)
        return(false);    

    Ret = fputs(SrcBuf,m_Fp);
         
    CloseFile();
    if(Ret == EOF)
        return(false);
    return true;
}
/*-----------------------------------------------------------------------------------------------
RemoveFile: Löschen einer Datei auf der SD Card
-----------------------------------------------------------------------------------------------*/
int StorageCard::RemoveFile(char *fName)
{
    return(remove(fName));
}
/*-----------------------------------------------------------------------------------------------
AppendSdValueToLine: Löschen einer Datei auf der SD Card
-----------------------------------------------------------------------------------------------*/
int StorageCard::AppendSdValueToLine()
{
    strcat (cSdLine, cSdValue);
    return(true);
}
// Methoden speziell fuer die KonfigurationsDatei mit den Autostartvariablen
/*-----------------------------------------------------------------------------------------------
OpenAutoFile: Öffnet eine Datei fuer den AutoStart
Returnwert ist true bei erfolgreichem Öffnen
Returnwert ist false bei fehlerhaftem Öffnen
-----------------------------------------------------------------------------------------------*/
int StorageCard::OpenAutoFile(char *FName, char *OpenMode) 
{
    if(m_fAutoFileIsOpen == true)       // ist bereits geoeffnet oder wurde nicht geschlossen 
    {
		printf("AutoFileIsOpened\n");
		return(false);              // ist nur zur Sicherheit
    }
/*    else
    {
		sprintf(HostIf.strErrorBuf,"%c#ER#Error open Autofile %s.  %c\r\n", STX, FName, ETX); // 
		HostIf.fSendError = true;
	    return(false);              // ist nur zur Sicherheit
    }        
*/            
	m_FpAutoFile = fopen(FName, OpenMode);   //  Datei im OpenMode öffnen
   if(m_FpAutoFile == NULL)    // Fehler beim Öffnen der Datei, der wesentliche Grund ist, das die Datei nicht vorhanden ist. 
                        // Die Konsequenz ist, daß die Quelldaten initialisiert werden müssen, eine Fehlermeldung muss nicht ausgegeben werden,
                        // es dürfen jedoch keine weiteren Daten aus der Datei gelesen werden. 
   {
		printf("AutoFilePointer is zero, no File with Autostart configurations\n");
        return(false);
   }
   m_fAutoFileIsOpen = true;
   
   rewind(m_FpAutoFile);
   return(true);    
}
/*-----------------------------------------------------------------------------------------------
ReadAutoLine: Liest eine Zeile aus der geöffneten AutoDatei 
Wenn der Pointer von fgets nach dem Leseversuch NULL ist, dann wurde nichts mehr gelesen 
und die Datei wird automatisch geschlossen, d.h. die lesende Funktion muss nur so lange lesen
bis false zurückkommt.  
-----------------------------------------------------------------------------------------------*/
int StorageCard::ReadAutoLine(char *Dest, int MaxLen) 
{
   if(m_fAutoFileIsOpen == true)
    {
        if(fgets(Dest, MaxLen , m_FpAutoFile) != NULL )
            return(strlen(Dest));
        clearerr(m_FpAutoFile);        
    }
   return(false);
}

/*-----------------------------------------------------------------------------------------------
WriteAutoLine: Schreibt eine Zeile in die geöffneten Datei 
Wenn beim Schreiben ein Fehler auftrifft, dann wird false zurückgegeben, ansonsten true.
-----------------------------------------------------------------------------------------------*/
int StorageCard::WriteAutoLine() 
{   
   if(m_fAutoFileIsOpen == true)
   {
        fputs(cSdLine, m_FpAutoFile);
        if (ferror (m_FpAutoFile))
        {
            clearerr(m_FpAutoFile);        
            fclose(m_FpAutoFile);        
            m_fAutoFileIsOpen = false;
            return(false);
        }
        fflush(m_FpAutoFile);
#ifdef RWFILE_DEBUG 
     printf ("%s",cSdLine);
#endif
        return(true);
   }
  
   return(false);
}

/*-----------------------------------------------------------------------------------------------
CloseAutoFile: Schließt eine geöffnete Datei
Returnwert ist true bei erfolgreichem Schliessen
Returnwert ist false bei fehlerhaftem Schliessen
-----------------------------------------------------------------------------------------------*/
int StorageCard::CloseAutoFile() 
{
    if(m_fAutoFileIsOpen == true)
    {
        clearerr(m_FpAutoFile);        
        fflush(m_FpAutoFile); 
        fclose(m_FpAutoFile);   //  Datei zu
        m_fAutoFileIsOpen = false;
        m_FpAutoFile = NULL;
        return(true);  
    }
    return(false);  
}


// Methoden fuer das Schreiben von Automessdaten
/*-----------------------------------------------------------------------------------------------
OpenAutoFile: Öffnet eine Datei fuer den AutoStart
Returnwert ist true bei erfolgreichem Öffnen
Returnwert ist false bei fehlerhaftem Öffnen
-----------------------------------------------------------------------------------------------*/
int StorageCard::OpenMwAutoFile(char *FName, char *OpenMode) 
{
    if(m_fMwAutoFileIsOpen == true)       // ist bereits geoeffnet oder wurde nicht geschlossen 
    {
#ifdef SEND_DEBUG_TO_HOST    
		printf("MwAutoFileIsOpened\n");
#endif
		return(false);              // ist nur zur Sicherheit
    }        
	m_FpMwAutoFile = fopen(FName, OpenMode);   //  Datei im OpenMode öffnen
   if(m_FpMwAutoFile == NULL)    // Fehler beim Öffnen der Datei, der wesentliche Grund ist, das die Datei nicht vorhanden ist. 
                        // Die Konsequenz ist, daß die Quelldaten initialisiert werden müssen, eine Fehlermeldung muss nicht ausgegeben werden,
                        // es dürfen jedoch keine weiteren Daten aus der Datei gelesen werden. 
   {
        return(false);
   }
   m_fMwAutoFileIsOpen = true;
   
   rewind(m_FpMwAutoFile);
   return(true);    
    
}
/*-----------------------------------------------------------------------------------------------
WriteAutoLine: Schreibt eine Zeile in die geöffneten Auto Datei 
Wenn beim Schreiben ein Fehler auftrifft, dann wird false zurückgegeben, ansonsten true.
-----------------------------------------------------------------------------------------------*/
int StorageCard::WriteMwAutoLine() 
{   
   if(m_fMwAutoFileIsOpen == true)
   {
        fputs(strFileRwBuf, m_FpMwAutoFile);
        if (ferror (m_FpMwAutoFile))
        {
            clearerr(m_FpMwAutoFile);        
            fclose(m_FpMwAutoFile);        
            m_fMwAutoFileIsOpen = false;
            return(false);
        }
        return(true);
   }
   return(false);
}
/*-----------------------------------------------------------------------------------------------
CloseAutoFile: Schließt die Auto Datei
Returnwert ist true bei erfolgreichem Schliessen
Returnwert ist false bei fehlerhaftem Schliessen
-----------------------------------------------------------------------------------------------*/
int StorageCard::CloseMwAutoFile() 
{
    if(m_fMwAutoFileIsOpen == true)
    {
        clearerr(m_FpMwAutoFile);        
        fflush(m_FpMwAutoFile); 
        fclose(m_FpMwAutoFile);   //  Datei zu
        m_fMwAutoFileIsOpen = false;
        m_FpMwAutoFile = NULL;
        return(true);  
    }
    return(false);  
}
