/*-------------------------------------------------------------------------------
Programm Name:  SendTelToHost.cpp
Version:        1.0
Sprache:        C
Compiler:       mbed Ver. 5.0
Autor:          PS
Copyright:      PS
                
Funktion:       Sendet die Telegramme an den EcmWin Rechner
28.10.2012: 
-------------------------------------------------------------------------------*/
#include "Headers.h"

/*-------------------------------------------------------------------------------
SendAnalogValues: Schickt was fertig ist
-------------------------------------------------------------------------------*/
int SendAnalogValues()
{
#ifdef PGU_EDUCATION
	SendAnalogFromEdu();
#endif
#ifdef PGU_RPA                
	SendRpaAnalogValues();
#else
	SendAnalogFromTouch();
#endif
    return(true);
}

/*-------------------------------------------------------------------------------
SendAnalogValues: Schickt was fertig ist
-------------------------------------------------------------------------------*/
int SendAnalogFromEdu()
{
    int j, Ret;
    
    Ret = false;
    if(MVars.m_fStartTel == 0x01)   // STX schicken
    {
        if(MVars.m_fFinishMeasurement == true)
        {
            MVars.nMessZustand[0] = 0;
            MVars.m_fSendStatus = true;
            MVars.m_fFinishMeasurement = false;
            MVars.m_fMeasurementFinished = true;
        }
            
        if(MVars.m_fSendStatus == true) // Status senden
            SendStatus();
        if(HostIf.fSendMessage == true) // Status senden
        {
            HostIf.fSendMessage = false;
            RpaDev.puts(HostIf.strMessageBuf);
        }
        if(HostIf.fSendError == true) // Status senden
        {
            HostIf.fSendError = false;
            RpaDev.puts(HostIf.strErrorBuf);
        }
        
        MVars.nTelLen = sprintf(STemp,"%c#MW#%d#",STX,MVars.m_nAnzValue);
        strcpy(HostIf.strTempBuf, STemp);
        MVars.m_fStartTel = 0x00;
    }

    for(j=0;j<2;j++)
    {
            if(MVars.m_fChnValid[j] == true)
            {
                MVars.nTelLen += sprintf(STemp,"%06lu#",(UINT32)MVars.dbAdResult[j]);
                strcat(HostIf.strTempBuf, STemp);
            }
    }
    MVars.m_nSendAnz++;
    if(MVars.m_nSendAnz >= MVars.m_nAnzValue)
    {
        MVars.nTelLen += sprintf(STemp,"%c",ETX);
        strcat(HostIf.strTempBuf, STemp);
        MVars.m_fStartTel = 0x01;
        MVars.m_nSendAnz = 0;
        if(MVars.m_fMeasurementFinished == true)
        {
            SetMessungEnde();
        }
#ifndef PGU_RPA                
        if(g_fDoCheckIRange == true)
        {     
            CheckIRange();
            g_fDoCheckIRange = false;
        }
#endif        
        Ret = true;
    }
    if(MVars.m_nSendValues == 2)    // senden während Messung
    {
//        if(g_fDisableSendMw == false)
        	RpaDev.puts((const char *)HostIf.strTempBuf);
        MVars.nTelLen = 0;
        HostIf.strTempBuf[0] = 0x00;
    }
    else
    {
//        if(g_fDisableSendMw == false)
	        RpaDev.puts(HostIf.strTempBuf);
        MVars.nDestCount = 0;
        HostIf.strTempBuf[0] = 0x00;
    }
  
    return(Ret);
}


/*-------------------------------------------------------------------------------
SendAnalogValues: Schickt was fertig ist
-------------------------------------------------------------------------------*/
int SendAnalogFromTouch()
{
    int j, Ret;
    
#ifndef PGU_RPA    
    if(MVars.m_fMessDlgOpened == false)
        return(true);   // wenn im Config Mode, keine Messtelegramme schicken

    Ret = false;
    if(MVars.m_fStartTel == 0x01)   // STX schicken
    {
        if(MVars.m_fFinishMeasurement == true)
        {
//            MVars.nMessZustand[0] = 0;
            MVars.m_fSendStatus = true;
            MVars.m_fFinishMeasurement = false;
            MVars.m_fMeasurementFinished = true;
        }
        if(HostIf.fIsConnected == false)    // hat keine Verbindung hergestellt
            return(true);
        if(g_nSendDisableTimer > 0)
        	return(true);
        	    
//        CheckIRange();  // wenn er hier umschaltet, dann ist der SendDisableTimer > 0 und ein Status wird gesendet
        if(MVars.m_fSendStatus == true) // Status senden
        {
            SendStatus();
	        if(g_nSendDisableTimer > 0)
    	    	return(true);
        }
        if(IrComp.fSendInfo == true)
        {
            SendInfo();
            IrComp.fSendInfo = false;
        }
        if(HostIf.fSendMessage == true) // Status senden
        {
            HostIf.fSendMessage = false;
            RpaDev.puts(HostIf.strMessageBuf);
        }
        if(HostIf.fSendError == true) // Status senden
        {
            HostIf.fSendError = false;
            RpaDev.puts(HostIf.strErrorBuf);
        }
        
        MVars.nTelLen = sprintf(STemp,"%c#MW#%d#",STX,MVars.m_nAnzValue);
        strcpy(HostIf.strTempBuf, STemp);
        MVars.m_fStartTel = 0x00;
    }

    for(j=0;j<2;j++)
    {
        if(MVars.m_fChnValid[j] == true)
        {
            MVars.nTelLen += sprintf(STemp,"%08lu#",(UINT32)AdVal->AdResult[j][g_nAdCount]);
			strcat(HostIf.strTempBuf, STemp);
#ifdef TFT_DEBUG 
//     printf ("Buf:%s   Val:%f   j:%d    Pos:%d  \n",STemp, AdVal->AdResult[j][g_nAdCount], j, g_nAdCount );
#endif
        }
    }
    if(MVars.m_fChnValid[2] == true)
    {
        MVars.nTelLen += sprintf(STemp,"%08lu#",(UINT32)AdVal->dbUFkResult);
        strcat(HostIf.strTempBuf, STemp);
    }
    if(MVars.m_fChnValid[3] == true)
    {
        MVars.nTelLen += sprintf(STemp,"%08lu#",(UINT32)AdVal->dbIFkResult);
        strcat(HostIf.strTempBuf, STemp);
    }
    
    MVars.m_nSendAnz++;
    if(MVars.m_nSendAnz >= MVars.m_nAnzValue)
    {
//        sprintf(STemp,"%d#%d#%c\r\n",g_fAd0State, g_fAd1State,ETX);
        MVars.nTelLen += sprintf(STemp,"%c\r\n",ETX);
        strcat(HostIf.strTempBuf, STemp);
        MVars.m_fStartTel = 0x01;
        MVars.m_nSendAnz = 0;
        if(MVars.m_fMeasurementFinished == true)
        {
            SetMessungEnde();
        }        
        Ret = true;
    }
    if(MVars.m_nSendValues == 2)    // senden während Messung
    {
        if(g_fDisableSendMw == false)
        	RpaDev.puts((const char *)HostIf.strTempBuf);
        MVars.nTelLen = 0;
        HostIf.strTempBuf[0] = 0x00;
    }
    else
    {
        if(g_fDisableSendMw == false)
	        RpaDev.puts(HostIf.strTempBuf);
        MVars.nDestCount = 0;
        HostIf.strTempBuf[0] = 0x00;
    }
#endif    
    return(Ret);
}

//-----------------------------------------------------------------------
// SendStatus: Senden des Status, da sich etwas geändert hat 
//-----------------------------------------------------------------------
void SendStatus(void) 
{
#ifdef PGU_RPA
	SendRpaStatus();
#else	    
    sprintf(HostIf.strTempBuf,"%c#ST#%d#%d#%d#%d#%d#%c\r\n",STX,MVars.nMessZustand[0], IRange.AktRange[0], GenW[0].nAktZyklus,IRange.m_fCheckRange,MVars.m_fPotGal,ETX);
    MVars.m_fSendStatus = false;
    RpaDev.puts(HostIf.strTempBuf);
#endif    
}
//-----------------------------------------------------------------------
// SendInfo: Senden des Infotelegramms
//-----------------------------------------------------------------------
void SendInfo(void) 
{
    IrComp.fSendInfo = false;
    RpaDev.puts(HostIf.strTempBuf);
}/*-------------------------------------------------------------------------------
SendAnalogValues: Schickt was fertig ist
-------------------------------------------------------------------------------*/
int SendRpaAnalogValues()
{
    int j, Ret;
    
    Ret = false;
    if(MVars.m_fStartTel == 0x01)   // STX schicken
    {
        if(MVars.m_fFinishMeasurement == true)
        {
            MVars.nMessZustand[0] = 0;
            MVars.m_fSendStatus = true;
            MVars.m_fFinishMeasurement = false;
            MVars.m_fMeasurementFinished = true;
        }
            
        if(MVars.m_fSendStatus == true) // Status senden
        {
            SendStatus();
            HostIf.strTempBuf[0] = 0x00;
        }
        if(HostIf.fSendMessage == true) // Status senden
        {
            HostIf.fSendMessage = false;
            RpaDev.puts(HostIf.strMessageBuf);
        }
        if(HostIf.fSendError == true) // Status senden
        {
            HostIf.fSendError = false;
            RpaDev.puts(HostIf.strErrorBuf);
        }
        
        MVars.nTelLen = sprintf(STemp,"%c#MW#%d#",STX,MVars.m_nAnzValue);
        strcat(HostIf.strTempBuf, STemp);
        MVars.m_fStartTel = 0x00;
    }

    for(j=0;j<3;j++)
    {
            if(MVars.m_fChnValid[j] == true)
            {
                MVars.nTelLen += sprintf(STemp,"%08u#",(UINT32)MVars.dbAdResult[j]);
#ifdef TFT_DEBUG    
//    printf("AdResult_x: %f  STemp: %s \n",MVars.dbAdResult[j], STemp);
#endif    
                strcat(HostIf.strTempBuf, STemp);
            }
    }
    MVars.m_nSendAnz++;
    if(MVars.m_nSendAnz >= MVars.m_nAnzValue)
    {
//        sprintf(STemp,"%d#%d#%c\r\n",g_fAd0State, g_fAd1State,ETX);
        MVars.nTelLen += sprintf(STemp,"%c",ETX);
        strcat(HostIf.strTempBuf, STemp);
        MVars.m_fStartTel = 0x01;
        MVars.m_nSendAnz = 0;
        if(MVars.m_fMeasurementFinished == true)
        {
            SetMessungEnde();
        }        
        Ret = true;
    }
    if(MVars.m_nSendValues == 2)    // senden während Messung
    {
        RpaDev.puts((const char *)HostIf.strTempBuf);
        MVars.nTelLen = 0;
        HostIf.strTempBuf[0] = 0x00;
    }
    else
    {
        RpaDev.puts(HostIf.strTempBuf);
        MVars.nDestCount = 0;
        HostIf.strTempBuf[0] = 0x00;
    }
    return(Ret);
}
//-----------------------------------------------------------------------
// SendStatus: Senden des Status, da sich etwas geändert hat 
//-----------------------------------------------------------------------
void SendRpaStatus(void) 
{
    
    sprintf(HostIf.strTempBuf,"%c#ST#%d#%c",STX,MVars.nMessZustand[0], ETX);
    MVars.m_fSendStatus = false;
    RpaDev.puts(HostIf.strTempBuf);
}

/*-----------------------------------------------------------------------
// SendTelToHost: Sendemethode fuer alle Telegramme. Die rufende Methode 
uebergibt des zu sendenden String. 
Findet sich in dem String ein CR, dann wird das uebersprungen. Findet sich ein 
LF, dann wird dies durch ein $ ersetzt. Folgen weitere Telegramme zu einem 
Funktionsblock, dann wird kein ETX gesendet. 
Handelt es sich um laengere Telegramme wie z.B. um Messdateien, dann werden 
groessere Bloecke mit Kennung, STX und ETX gesendet. Das letzte Telegramm bekommt
dann eine EOF vor das ETX, damit kann das Zielsystem erkennen, das die Datei 
fertig ist.  
-----------------------------------------------------------------------*/
void SendTelToHost(bool fMoreThanOne, bool fEof, int fReplace) 
{
	int Len, i, j, k;
	
    Len = strlen(HostIf.strTempBuf);
	j = 0; // zur Sicherheit
	for(i=0, j=0, k=0;i<Len;i++, j++)
	{
		if(HostIf.strTempBuf[i] == 0x0D)   j--;  // das naechste j++ wird ausgeglichen
		else if(HostIf.strTempBuf[i] == 0x0A)   
		{
			if(fReplace == 0)
				HostIf.strFinalSendBuf[j] = REPLACE_LATTEN_ZAUN;  // Zeilenende wird mit # gekennzeichnet
			else if(fReplace == 1)
				HostIf.strFinalSendBuf[j] = REPLACE_LF;  // Zeilenende wird mit $ gekennzeichnet
			else
				HostIf.strFinalSendBuf[j] = HostIf.strTempBuf[i];
		}
		else 
			HostIf.strFinalSendBuf[j] = HostIf.strTempBuf[i];
			
    }
	if(fMoreThanOne == true)
	{
		HostIf.strFinalSendBuf[j] = 0x00; // kein ETX, es geht weiter
	}
	else
	{
		if(fEof == true)	// war eine grosse Datei, muss mit EOF gesendet werden
		{
			HostIf.strFinalSendBuf[j] = MCU_EOF;	j++;
		}
		if(Len == 0)	j = 0;
		HostIf.strFinalSendBuf[j] = ETX;
		HostIf.strFinalSendBuf[j+1] = 0x00;
	}
    RpaDev.puts((const char *)HostIf.strFinalSendBuf);
#ifdef TFT_DEBUG    
//     printf("WriteFile is: %s\n",TcpSendBuf);
#endif          
}
