/*-------------------------------------------------------------------------------
Programm Name:  SioGlobals.h
Version:        1.0
Sprache:        C++
Compiler:       mbed
Autor:          PS
Copyright:      PS
                 

Funktion:       Globale Kommunikations-Variablen und Methoden
 
-------------------------------------------------------------------------------*/

#define STX     0x21
#define ETX     0x7C

#define MCU_EOF    0x7D  // } MyEndOfFile
#define REPLACE_LF     0x24	// $
#define REPLACE_LATTEN_ZAUN		'#'
#define SEND_BUF_LEN 	4096
#define TEMP_BUF_LEN 	1024
#define MSG_BUF_LEN		256

/*===========================================================================
 Struktur f�r das Kommunikationshandling zwischen EcmWin und der Firmware
 Es kann sich dabei um eine RS232, Ethernet oder in Zukunft ev. auch um ein 
 USB Interface handeln
===========================================================================*/
struct HostInterface
{
	char 	strRecBuf[SEND_BUF_LEN]; // Empfangspuffer fuer die eingehenden Zeichen
	int 	nRecStartPos;
	int 	nRecEndPos;
	int 	nEtxPos;
    int    	nInTel;
	char 	strTelAwBuf[SEND_BUF_LEN]; // Puffer zum Auswerten des gesendeten Telegrammes
	
	char 	TelCode[8];
	int 	nTelLen;
	char 	*ptrTelPos;
	
	char 	strTempBuf[TEMP_BUF_LEN];
	char 	strFinalSendBuf[SEND_BUF_LEN];
	char 	strCommonTmpBuf[SEND_BUF_LEN];
	char 	strMessageBuf[MSG_BUF_LEN];
	char 	strErrorBuf[MSG_BUF_LEN];
	int 	nAwTelLen;
	
    int     nRecInPos; 
	bool 	fStartTel;
//    bool    fConnect, fEthInitDone, fEthConnect,fAfterBind, fAfterCheckWait, fEcmWinIsConnected, fEcmWinStartClose, fEcmWaitForRequest;
    int     fSendStatus;
    int     nDisconnectCounter;
    bool 	fIsConnected;
	bool 	fAfterCheckWait;
	bool 	fEcmWinIsConnected;
	bool 	fEcmWinStartClose;
	bool 	fAfterBind;
	bool 	fAfterOpen;
	bool 	fEcmWaitForRequest;
	bool 	fSendMessage, fSendError;
};
typedef struct HostInterface HOST_INTERFACE;

// ETH_IN_OUT;


extern HOST_INTERFACE HostIf;

extern char STemp[128];


