/*
-------------------------------------------------------------------------------
Programm Name: OpenIni.h
Version:       1.0
Sprache:       C
Compiler:      MBED
Autor:         PS
Copyright:     PS
               

Funktion:      Externdeklarationen für die IniDatei
-------------------------------------------------------------------------------
*/

/*===========================================================================
Die nachfolgende Struktur dient zur Speicherung der Ini-Daten
===========================================================================*/
struct EcmIni
{
    char    DevTyp[32];    // Gerätetyp
    int     nPotCode;    // Codierung, welche Hardware angeschlossen ist
    char    DevSio[16];    // Seriennummer des Gerätes
    char    SwLizenz[16];  // Lizenznummer der Software
    char    SwRev[16];     // Revisionsnummer der Software
    char    IpAddress[32]; // eigene IP-Adresse für Netzwerkbetrieb
    char    SubNet[32];    // Sub-Net Mask für Netzwerkbetrieb
    char    Gateway[32]; // IP-Adresse für Gateway
    int     nOnlyTcp;
    char    HostIp[32];    // IP-Adresse für Host
    int     nPortNr;        // Portnummer für Ethernet 
    int     nExtStart;      // wenn true, dann kann ein externer Start über einen Eingangskontakt erfolgten
    int     nSExtChnNr;     // Kanalnummer zum Einlesen für externen Start
    int     nAnzChannel;
    double  dbRpmOffset;
    double  dbRpmScale;
    bool    fCfgExists;
    double  dbAoScale;
    double  dbAoOffset;
    int     nReInit;
    int     nNrOff;
    double  dbUOffset[8];
    double  dbUScale[8];
};
typedef struct EcmIni ECM_INI;


extern char IniKey[50][16];

extern int OpenIni();
extern int DecodeIniValues(char *Src);


extern int InitDefault();
extern int WriteIni();


extern int DecDevTyp(char *Line);
extern int DecPotCode(char *Line);
extern int DecSerNr(char *Line);
extern int DecLzNr(char *Line);
extern int DecRevNr(char *Line);
extern int DecIpAddr(char *Line);
extern int DecSubNet(char *Line);
extern int DecGateway(char *Line);
extern int DecHostIp(char *Line);
extern int DecPortNo(char *Line);
extern int DecExtStart(char *Line);
extern int DecSextChnNr(char *Line);
extern int DecRpmOffset(char *Line);
extern int DecRpmScale(char *Line);
extern int DecAoScale(char *Line);
extern int DecAoOffset(char *Line);
extern int DecReInit(char *Line);
extern int DecNrOff(char *Line);

extern int DecU0Offset(char *Line);
extern int DecU1Offset(char *Line);
extern int DecU2Offset(char *Line);
extern int DecU3Offset(char *Line);
extern int DecU4Offset(char *Line);
extern int DecU5Offset(char *Line);
extern int DecU6Offset(char *Line);
extern int DecU7Offset(char *Line);

extern int DecU0Scale(char *Line);
extern int DecU1Scale(char *Line);
extern int DecU2Scale(char *Line);
extern int DecU3Scale(char *Line);
extern int DecU4Scale(char *Line);
extern int DecU5Scale(char *Line);
extern int DecU6Scale(char *Line);
extern int DecU7Scale(char *Line);

