/*
-------------------------------------------------------------------------------
Programm Name: OpenIni.CPP
Version:       1.0
Sprache:       C
Compiler:      MBED
Autor:         PS
Copyright:     PS
               

Funktion:      Oeffnen die zusätzliche Ini-Datei. Falls nicht vorhanden,
               Basisinitialisierung.
-------------------------------------------------------------------------------
*/
/*
-------------------------------------------------------------------------------
Zuordnung der Konfigurationsvariablen. Folgende Informationen sollten verarbeitet
werden: 08.01.2008
Diese Ini-Datei soll so gestaltet sein, daß Zeilen angehängt werden können.
Zunächst sollen folgende Inhalte aufgenommen werden:
1. Seriennummer des Potentiostaten
2. Lizenznummer der Software
3. Revisionsnummer der Software
4. Offsetkorrekturwert für die Analogausgabe
5. Netzwerkadresse  z.B. 192.168.2.99


-------------------------------------------------------------------------------
*/
/*-------------------------------------------------------------------------------
-------------------------------------------------------------------------------*/
#include "Headers.h"

/*-------------------------------------------------------------------------------
Variablen für die Ini-Datei
-------------------------------------------------------------------------------*/

                // 0         1           2       3       4           5           6           7           8           9               10          11
/*char *Key[34] = {"DEV_TYP", "POT_CODE", "SER_NR", "LZ_NR", "REV_NR", "IP_ADR",  "SUB_NET", "GATEWAY", "HOST_IP", "PORT_NO", \
"EXT_START", "SEXT_CHN_NR", "RPM_OFFSET", "RPM_SCALE", "AO_SCALE", "AO_OFFSET", "RE_INIT", "NR_OFF",
"A0_OFFSET", "A1_OFFSET", "A2_OFFSET", "A3_OFFSET", "A4_OFFSET", "A5_OFFSET", "A6_OFFSET", "A7_OFFSET",
"A0_SCALE", "A1_SCALE", "A2_SCALE", "A3_SCALE", "A4_SCALE", "A5_SCALE", "A6_SCALE", "A7_SCALE"
};    // bis hier 93
*/
// Zeile = 50, Spalte = 16
char IniKey[50][16];


int posKey, posEqual, posValueEnd;

int (*KeyPtr[])(char *) =  {DecDevTyp, DecPotCode, DecSerNr, DecLzNr,DecRevNr, DecIpAddr, DecSubNet, DecGateway, DecHostIp, DecPortNo, \
                            DecExtStart, DecSextChnNr, DecRpmOffset, DecRpmScale, DecAoScale, DecAoOffset,DecReInit, DecNrOff,
                            DecU0Offset, DecU1Offset, DecU2Offset, DecU3Offset, DecU4Offset, DecU5Offset, DecU6Offset, DecU7Offset, 
                            DecU0Scale, DecU1Scale, DecU2Scale, DecU3Scale, DecU4Scale, DecU5Scale, DecU6Scale, DecU7Scale 
                             };


/*-------------------------------------------------------------------------------
SetIniKey: Beschreiben der Felder mit den INiKeys
-------------------------------------------------------------------------------*/
void SetIniKey()
{
	int i;
	
	i = 0;
	strcpy(IniKey[i++], "DEV_TYP");
	strcpy(IniKey[i++], "POT_CODE");
	strcpy(IniKey[i++], "SER_NR");
	strcpy(IniKey[i++], "LZ_NR");
	strcpy(IniKey[i++], "REV_NR");
	strcpy(IniKey[i++], "IP_ADR");
	strcpy(IniKey[i++],  "SUB_NET");
	strcpy(IniKey[i++], "GATEWAY");
	strcpy(IniKey[i++], "HOST_IP");
	strcpy(IniKey[i++], "PORT_NO");
	
	strcpy(IniKey[i++], "EXT_START");
	strcpy(IniKey[i++], "SEXT_CHN_NR");
	strcpy(IniKey[i++], "RPM_OFFSET");
	strcpy(IniKey[i++], "RPM_SCALE");
	strcpy(IniKey[i++], "AO_SCALE");
	strcpy(IniKey[i++], "AO_OFFSET");
	strcpy(IniKey[i++], "RE_INIT");
	strcpy(IniKey[i++], "NR_OFF");
	strcpy(IniKey[i++], "A0_OFFSET");
	strcpy(IniKey[i++], "A1_OFFSET");
	strcpy(IniKey[i++], "A2_OFFSET");
	strcpy(IniKey[i++], "A3_OFFSET");
	strcpy(IniKey[i++], "A4_OFFSET");
	strcpy(IniKey[i++], "A5_OFFSET");
	strcpy(IniKey[i++], "A6_OFFSET");
	strcpy(IniKey[i++], "A7_OFFSET");
	strcpy(IniKey[i++], "A0_SCALE");
	strcpy(IniKey[i++], "A1_SCALE");
	strcpy(IniKey[i++], "A2_SCALE");
	strcpy(IniKey[i++], "A3_SCALE");
	strcpy(IniKey[i++], "A4_SCALE");
	strcpy(IniKey[i++], "A5_SCALE");
	strcpy(IniKey[i++], "A6_SCALE");
	strcpy(IniKey[i++], "A7_SCALE");
}

/*-------------------------------------------------------------------------------
Datei öffnen
-------------------------------------------------------------------------------*/
int OpenIni()
{
    int i,j,Ret;
    char strKeyCode[64];
    char strValue[128];
    
    
    InitDefault();      // vor den Lesen defautl initialisieren
#ifdef SINGLE_DEBUG        
        printf("Nach InitDfault\n");
#endif        
        
    if(g_SdInitSuccess == false)    // wenn SD Karte nicht vorhanden, retour
    {
#ifdef SINGLE_DEBUG        
        printf("SD Card not present\n");
#endif        
    }
    
    Ret = clSdCard.OpenFile(FileNames.IniFileName, FileNames.FileReadMode);
    
    if(Ret == false)
    {
        WriteIni();     // Default erzeugen
        return(false);  // öffnen der Inidatei hat nicht geklappt
    }
        
    do
    {
        Ret = clSdCard.ReadLine(strFileRwBuf, FILE_RW_BUF_LEN);
        if(Ret > 0) // es sind Zeichen im Puffer
        {
#ifdef SINGLE_DEBUG        
//             printf("Buf:  %s\n",strFileRwBuf);
#endif        
            for(i=0;i<Ret;i++)
            {
                if( (strFileRwBuf[i] == 0x0A) || (strFileRwBuf[i] == 0x0D))
                {
                    strFileRwBuf[i] = 0x00;
                    i = Ret;
                }
                else if(strFileRwBuf[i] == 0x2C)    // Komma
                    strFileRwBuf[i] = 0x2E; // in Punkt 
            }
            i = 0;
            while( (i < 64) && (strFileRwBuf[i] != '=') )
            {
                strKeyCode[i] = strFileRwBuf[i];
                i++;
            }
            strKeyCode[i] = 0x00;
            i++;
            while( (strFileRwBuf[i] == ' ') && (i < 100) )
                i++;
            strcpy(strValue,&strFileRwBuf[i]);
            
            //printf("KeyCode: %s   Value: %s\n", strKeyCode, strValue);
            for(j = 0;j< ANZ_KEY;j++)
            {
                if(strcmp(strKeyCode, IniKey[j]) == 0) // die Strings stimmen überein
                {
                     (*KeyPtr[j])((char *)(strValue));  
                     j = ANZ_KEY;  
                }    
            }
        } 
    }        
    while(Ret > 0);
    clSdCard.CloseFile();
    EcmIni.fCfgExists = true;
    if(EcmIni.nReInit == 1)
    {
        EcmIni.nReInit = 0;
        InitDefault();
        WriteIni();     // Default erzeugen
    }
    
    
    return(true);
}
    
/*-------------------------------------------------------------------------------
Defaultwerte für die Inivariablen setzten
-------------------------------------------------------------------------------*/
int InitDefault()
{
    int i;
    
    strcpy(EcmIni.DevTyp,"RPA-Device");    // Gerätetyp des Gerätes
    strcpy(EcmIni.DevSio,"200_xxx");    // Seriennummer des Gerätes
    strcpy(EcmIni.SwLizenz,"20000_xxx");  // Lizenznummer der Software
    strcpy(EcmIni.SwRev,SW_REV);     // Revisionsnummer der Software
    strcpy(EcmIni.IpAddress,"192.168.2.1"); // meine IP-Adresse für Netzwerkbetrieb
    strcpy(EcmIni.SubNet,"255.255.255.0"); // IP-Adresse für Netzwerkbetrieb
    strcpy(EcmIni.Gateway,"0.0.0.0"); // IP-Adresse für Netzwerkbetrieb
    strcpy(EcmIni.HostIp,"192.168.2.8"); // IP-Adresse für Netzwerkbetrieb
    
    EcmIni.nPotCode = 1;       // default PGU, Jaissle ist 0x00, 71 ist PGU-Stack
    EcmIni.nExtStart = 0;      // default kein externen Start
    EcmIni.nSExtChnNr = 0x00;  // default Kanalnummer 0 für externen Start
    EcmIni.nPortNr = 4000;  // Default 4000
    EcmIni.dbRpmOffset = 0.0;        // Offsetkorrektur für die Anzeige Drehzahl
    EcmIni.dbRpmScale = 1.0;        // Skalierungswert fuer die Anzeige Drehzahl
    EcmIni.dbAoScale = 13.107;      // Skalierungswert fuer den Analogausgang
    EcmIni.dbAoOffset = 0.0;       // Offset fuer den Analogausgang
    EcmIni.nReInit = 0;         // Flag für Reinitialisierung
    EcmIni.nNrOff = 0;          // Ausschalten der Drehzahlnachführung
    for(i=0;i<8;i++)
    {
        EcmIni.dbUOffset[i] = 0.0;
        EcmIni.dbUScale[i] = 1.0;
    }
    return(true);
}

/*-------------------------------------------------------------------------------
Datei speichern
-------------------------------------------------------------------------------*/
int WriteIni()
{
    int Ret,i, j;

    
    if(g_SdInitSuccess == false)    // wenn SD Karte nicht vorhanden, retour
    {
#ifdef TFT_DEBUG            
//        printf("SD Card not present\n");
#endif        
        return(false);
    }
    
    Ret = clSdCard.OpenFile(FileNames.IniFileName, FileNames.FileWriteMode);
    
    if(Ret == false)
        return(false);  // öffnen der Datei hat nicht geklappt

    i= 0;    
    // Methode CI
    
    
    
    sprintf(clSdCard.cSdLine, "%s=%s\r\n", IniKey[i],EcmIni.DevTyp);       clSdCard.WriteLine();   i++;        // DEV_TYP
    sprintf(clSdCard.cSdLine, "%s=%d\r\n", IniKey[i],EcmIni.nPotCode);     clSdCard.WriteLine();   i++;      // POT_CODE
    sprintf(clSdCard.cSdLine, "%s=%s\r\n", IniKey[i],EcmIni.DevSio);       clSdCard.WriteLine();   i++;        // SER_NR
    sprintf(clSdCard.cSdLine, "%s=%s\r\n", IniKey[i],EcmIni.SwLizenz);     clSdCard.WriteLine();   i++;      // LZ_NR
    sprintf(clSdCard.cSdLine, "%s=%s\r\n", IniKey[i],EcmIni.SwRev);        clSdCard.WriteLine();   i++;         // REV_NR
    sprintf(clSdCard.cSdLine, "%s=%s\r\n", IniKey[i],EcmIni.IpAddress);    clSdCard.WriteLine();   i++;     // IP_ADR
    sprintf(clSdCard.cSdLine, "%s=%s\r\n", IniKey[i],EcmIni.SubNet);       clSdCard.WriteLine();   i++;        // SUB_NET
    sprintf(clSdCard.cSdLine, "%s=%s\r\n", IniKey[i],EcmIni.Gateway);      clSdCard.WriteLine();   i++;       // GATEWAY
    sprintf(clSdCard.cSdLine, "%s=%s\r\n", IniKey[i],EcmIni.HostIp);       clSdCard.WriteLine();   i++;        // HOST_IP
    sprintf(clSdCard.cSdLine, "%s=%d\r\n", IniKey[i],EcmIni.nPortNr);      clSdCard.WriteLine();   i++;       // PORT_NO
    sprintf(clSdCard.cSdLine, "%s=%d\r\n", IniKey[i],EcmIni.nExtStart);    clSdCard.WriteLine();   i++;     // "EXT_START 
    sprintf(clSdCard.cSdLine, "%s=%d\r\n", IniKey[i],EcmIni.nSExtChnNr);   clSdCard.WriteLine();   i++;    // "SEXT_CHN_NR
    sprintf(clSdCard.cSdLine, "%s=%f\r\n", IniKey[i],EcmIni.dbRpmOffset);  clSdCard.WriteLine();   i++;    // 
    sprintf(clSdCard.cSdLine, "%s=%f\r\n", IniKey[i],EcmIni.dbRpmScale);   clSdCard.WriteLine();   i++;
    sprintf(clSdCard.cSdLine, "%s=%f\r\n", IniKey[i],EcmIni.dbAoScale);    clSdCard.WriteLine();   i++;
    sprintf(clSdCard.cSdLine, "%s=%f\r\n", IniKey[i],EcmIni.dbAoOffset);   clSdCard.WriteLine();   i++;
    sprintf(clSdCard.cSdLine, "%s=%d\r\n", IniKey[i],EcmIni.nReInit);      clSdCard.WriteLine();   i++;
    sprintf(clSdCard.cSdLine, "%s=%d\r\n", IniKey[i],EcmIni.nNrOff);       clSdCard.WriteLine();   i++;

    for(i=0, j=18;i<8;i++, j++)
        sprintf(clSdCard.cSdLine, "%s=%f\r\n", IniKey[j],EcmIni.dbUOffset[i]);    clSdCard.WriteLine();   i++;
    for(i=0, j=26;i<8;i++, j++)
        sprintf(clSdCard.cSdLine, "%s=%f\r\n", IniKey[j],EcmIni.dbUScale[i]);    clSdCard.WriteLine();   i++;

    clSdCard.CloseFile();
    return(true);

}


//--------------------------------------------------------------------------
// DecDevTyp: Decodieren des Gerätetyps
//--------------------------------------------------------------------------
int DecDevTyp(char *Line)
{   
    strcpy(EcmIni.DevTyp,Line);     
#ifdef TFT_DEBUG        
        printf("DevTyp: %s\n", EcmIni.DevTyp);
#endif        
    return(true);   
}
//--------------------------------------------------------------------------
// DecPotCode: Decodieren 
//--------------------------------------------------------------------------
int DecPotCode(char *Line)
{   EcmIni.nPotCode = atoi(Line);   return(true);   }
//--------------------------------------------------------------------------
// Dec
//--------------------------------------------------------------------------
int DecSerNr(char *Line)
{   strcpy(EcmIni.DevSio,Line); return(true);   }
//--------------------------------------------------------------------------
// Dec
//--------------------------------------------------------------------------
int DecLzNr(char *Line)
{   strcpy(EcmIni.SwLizenz,Line);   return(true);   }
//--------------------------------------------------------------------------
// Dec
//--------------------------------------------------------------------------
int DecRevNr(char *Line)
{   strcpy(EcmIni.SwRev,Line);   return(true);   }
//--------------------------------------------------------------------------
// Dec
//--------------------------------------------------------------------------
int DecIpAddr(char *Line)
{   strcpy(EcmIni.IpAddress,Line);   return(true);   }
//--------------------------------------------------------------------------
// Dec
//--------------------------------------------------------------------------
int DecSubNet(char *Line)
{   strcpy(EcmIni.SubNet,Line);   return(true);   }
//--------------------------------------------------------------------------
// Dec
//--------------------------------------------------------------------------
int DecGateway(char *Line)
{   strcpy(EcmIni.Gateway,Line);   return(true);   }
//--------------------------------------------------------------------------
// Dec
//--------------------------------------------------------------------------
int DecHostIp(char *Line)
{   strcpy(EcmIni.HostIp,Line);   return(true);   }
//--------------------------------------------------------------------------
// Dec
//--------------------------------------------------------------------------
int DecPortNo(char *Line)
{   EcmIni.nPortNr = atoi(Line);   return(true);   }
//--------------------------------------------------------------------------
// Dec
//--------------------------------------------------------------------------
int DecExtStart(char *Line)
{   EcmIni.nExtStart = atoi(Line);   return(true);   }
//--------------------------------------------------------------------------
// Dec
//--------------------------------------------------------------------------
int DecSextChnNr(char *Line)
{   EcmIni.nSExtChnNr = atoi(Line);   return(true);   }

//--------------------------------------------------------------------------
// Dec
//--------------------------------------------------------------------------
int DecRpmOffset(char *Line)
{   EcmIni.dbRpmOffset = atof(Line);   return(true);   }
//--------------------------------------------------------------------------
// Dec
//--------------------------------------------------------------------------
int DecRpmScale(char *Line)
{   EcmIni.dbRpmScale = atof(Line);   return(true);   }

//--------------------------------------------------------------------------
// Dec
//--------------------------------------------------------------------------
int DecAoScale(char *Line)
{   EcmIni.dbAoScale = atof(Line);   return(true);   }

//--------------------------------------------------------------------------
// Dec
//--------------------------------------------------------------------------
int DecReInit(char *Line)
{   EcmIni.nReInit = atoi(Line);   return(true);   }

//--------------------------------------------------------------------------
// Dec
//--------------------------------------------------------------------------
int DecNrOff(char *Line)
{   EcmIni.nNrOff = atoi(Line);   return(true);   }

//--------------------------------------------------------------------------
// Dec
//--------------------------------------------------------------------------
int DecAoOffset(char *Line)
{   EcmIni.dbAoOffset = atof(Line);   
    return(true);   
}

//--------------------------------------------------------------------------
// Dec
//--------------------------------------------------------------------------
int DecU0Offset(char *Line)
{   EcmIni.dbUOffset[0] = atof(Line);   
    EcmIni.dbUOffset[0] *= 838860.;
    return(true);   
}
//--------------------------------------------------------------------------
// Dec
//--------------------------------------------------------------------------
int DecU1Offset(char *Line)
{   EcmIni.dbUOffset[1] = atof(Line);   
    EcmIni.dbUOffset[1] *= 838860.;
    return(true);   
}
 
 
//--------------------------------------------------------------------------
// Dec
//--------------------------------------------------------------------------
int DecU2Offset(char *Line)
{   EcmIni.dbUOffset[2] = atof(Line);   
    EcmIni.dbUOffset[2] *= 838860.;
    return(true);   
}
//--------------------------------------------------------------------------
// Dec
//--------------------------------------------------------------------------
int DecU3Offset(char *Line)
{   EcmIni.dbUOffset[3] = atof(Line);   
    EcmIni.dbUOffset[3] *= 838860.;
    return(true);   
}
//--------------------------------------------------------------------------
// Dec
//--------------------------------------------------------------------------
int DecU4Offset(char *Line)
{   EcmIni.dbUOffset[4] = atof(Line);   
    EcmIni.dbUOffset[4] *= 838860.;
    return(true);   
}
//--------------------------------------------------------------------------
// Dec
//--------------------------------------------------------------------------
int DecU5Offset(char *Line)
{   EcmIni.dbUOffset[5] = atof(Line);   
    EcmIni.dbUOffset[5] *= 838860.;
    return(true);   
}
//--------------------------------------------------------------------------
// Dec
//--------------------------------------------------------------------------
int DecU6Offset(char *Line)
{   EcmIni.dbUOffset[6] = atof(Line);   
    EcmIni.dbUOffset[6] *= 838860.;
    return(true);   
}
//--------------------------------------------------------------------------
// Dec
//--------------------------------------------------------------------------
int DecU7Offset(char *Line)
{   EcmIni.dbUOffset[7] = atof(Line);   
    EcmIni.dbUOffset[7] *= 838860.;
    return(true);  
}

//--------------------------------------------------------------------------
// Dec
//--------------------------------------------------------------------------
int DecU0Scale(char *Line)
{   EcmIni.dbUScale[0] = atof(Line);   return(true);   }
 
//--------------------------------------------------------------------------
// Dec
//--------------------------------------------------------------------------
int DecU1Scale(char *Line)
{   EcmIni.dbUScale[1] = atof(Line);   return(true);   }
//--------------------------------------------------------------------------
// Dec
//--------------------------------------------------------------------------
int DecU2Scale(char *Line)
{   EcmIni.dbUScale[2] = atof(Line);   return(true);   }
//--------------------------------------------------------------------------
// Dec
//--------------------------------------------------------------------------
int DecU3Scale(char *Line)
{   EcmIni.dbUScale[3] = atof(Line);   return(true);   }
//--------------------------------------------------------------------------
// Dec
//--------------------------------------------------------------------------
int DecU4Scale(char *Line)
{   EcmIni.dbUScale[4] = atof(Line);   return(true);   }
//--------------------------------------------------------------------------
// Dec
//--------------------------------------------------------------------------
int DecU5Scale(char *Line)
{   EcmIni.dbUScale[5] = atof(Line);   return(true);   }
//--------------------------------------------------------------------------
// Dec
//--------------------------------------------------------------------------
int DecU6Scale(char *Line)
{   EcmIni.dbUScale[6] = atof(Line);   return(true);   }
//--------------------------------------------------------------------------
// Dec
//--------------------------------------------------------------------------
int DecU7Scale(char *Line)
{   EcmIni.dbUScale[7] = atof(Line);   return(true);   }
 
 
 
 