/*
-------------------------------------------------------------------------------
Programm Name: OpenDevId.CPP
Version:       1.0
Sprache:       C
Compiler:      MBED
Autor:         PS
Copyright:     PS
               

Funktion:      Liest die ID-Datei und überträft diese an EcmWin. Damit kann 
                EcmWin den Gerätetyp eintragen. Wenn nicht vorhanden, dann kommt
                ein NAK
-------------------------------------------------------------------------------
*/
/*
-------------------------------------------------------------------------------

-------------------------------------------------------------------------------
*/
/*-------------------------------------------------------------------------------
-------------------------------------------------------------------------------*/
#include "Headers.h"

const char *DevIdKey[] = {"DEV_INDEX",    "POT_REV",      "POT_VAR",      "SCAN_VAR",     "POT_CHN",      "CURR_CHN",     "AMP_CHN",      "AMP_ACTIVE", "SW_IZ",      "SW_PG", \
                    "POT_INVERTED", "O_POT_INV",    "O_GAL_INV",    "GAL_VAR_VAL",  "U_N_CHN",      "I_N_CHN",      "I_N_ACTIVE",   "LPC_CAL_C0", "LPC_CAL_C1", "LPC_CAL_C2",\
                    "LPC_CAL_C3",   "LPC_CAL_C4",   "LPC_CAL_C5",   "LPC_CAL_C6",   "LPC_CAL_C7",   "INST_BOARD",   "S_RATE_ID",    "AV_VALUE" };


DEV_INI DevIni;

int (*DevKeyPtr[])(char *) =  {DecDevIndex, DecPotRev, DecPotVar, DecScanVar,DecPotChn, DecCurrChn, DecAmpChn, DecAmpActive, DecSwIz, DecSwPg, \
                            DecPotInverted, DecOPotInv, DecOGalInv,DecGalVarVal, DecUnChn, DecInChn, DecInActive, DecLpcCalC0, DecLpcCalC1, \
                            DecLpcCalC2, DecLpcCalC3, DecLpcCalC4,DecLpcCalC5, DecLpcCalC6, DecLpcCalC7, DecInstBoard, DecSRateId, DecAvValue };



/*-------------------------------------------------------------------------------
SetIniKey: Beschreiben der Felder mit den INiKeys
-------------------------------------------------------------------------------*/
void SetDevIdKey()
{
    int i;
    
    i = 0;

}

/*-------------------------------------------------------------------------------
Datei öffnen
-------------------------------------------------------------------------------*/
int OpenDevIni()
{
    int i,j, Ret;
    char strKeyCode[64];
    char strValue[64];

    InitDevIni();        
        
//    return;

    if(g_SdInitSuccess == false)    // wenn SD Karte nicht vorhanden, retour
    {
        sprintf(HostIf.strErrorBuf,"%c#ER#SD-Card is not acessable. %c\r\n", STX, ETX); // 
        HostIf.fSendError = true;
        if(g_fOnDuringInit)
            printf("%s",HostIf.strErrorBuf); 

        return(false);
    }
    
    Ret = clSdCard.OpenFile(FileNames.DevIdFileName, FileNames.FileReadMode);
    
    if(Ret == false)
    {
        WriteDevFile(); // Defaultdatei erzeugen
        sprintf(HostIf.strErrorBuf,"%c#ER#Error on open IniFile. Default created. %c\r\n", STX, ETX); // 
        HostIf.fSendError = true;
        if(g_fOnDuringInit)
            printf("%s",HostIf.strErrorBuf); 
        return(false);  // öffnen der Inidatei hat nicht geklappt
    }
        
    do
    {
        Ret = clSdCard.ReadLine(strFileRwBuf, FILE_RW_BUF_LEN);
        if(Ret > 0) // es sind Zeichen im Puffer
        {
            for(i=0;i<Ret;i++)
            {
                if( (strFileRwBuf[i] == 0x0A) || (strFileRwBuf[i] == 0x0D))
                {
                    strFileRwBuf[i] = 0x00;
                    i = Ret;
                }
                else if(strFileRwBuf[i] == 0x2C)    // Komma
                    strFileRwBuf[i] = 0x2E; // in Punkt 
            }
            i = 0;
            while( (i < 64) && (strFileRwBuf[i] != '=') )
            {
                strKeyCode[i] = strFileRwBuf[i];
                i++;
            }
            strKeyCode[i] = 0x00;
            i++;
            while( (strFileRwBuf[i] == ' ') && (i < 100) )
                i++;
            strcpy(strValue,&strFileRwBuf[i]);
            
            //printf("KeyCode: %s   Value: %s\n", strKeyCode, strValue);
            for(j = 0;j< ANZ_DEV_KEY;j++)
            {
                if(strcmp(strKeyCode, DevIdKey[j]) == 0) // die Strings stimmen überein
                {
                     (*DevKeyPtr[j])((char *)(strValue));  
                     j = ANZ_DEV_KEY;  
                }    
            }
        } 
    }        
    while(Ret > 0);
    clSdCard.CloseFile();
    EcmIni.fCfgExists = true;
//    EcmIni.fCalRange = true;

    return(true);
}

//--------------------------------------------------------------------------
// DecDevIndex: Decodieren 
//--------------------------------------------------------------------------
int DecDevIndex(char *Line)
{   DevIni.nDevIndex = atoi(Line);   return(true);   }
//--------------------------------------------------------------------------
// DecPotRev: Decodieren 
//--------------------------------------------------------------------------
int DecPotRev(char *Line)
{   DevIni.nPotRev = atoi(Line);   return(true);   }
//--------------------------------------------------------------------------
// DecPotVar: Decodieren 
//--------------------------------------------------------------------------
int DecPotVar(char *Line)
{   DevIni.dbPotVar = atof(Line);   return(true);   }
//--------------------------------------------------------------------------
// DecScanVar: Decodieren 
//--------------------------------------------------------------------------
int DecScanVar(char *Line)
{   DevIni.dbScanVar = atof(Line);   return(true);   }
//--------------------------------------------------------------------------
// DecPotChn: Decodieren 
//--------------------------------------------------------------------------
int DecPotChn(char *Line)
{   DevIni.nPotChn = atoi(Line);   return(true);   }
//--------------------------------------------------------------------------
// DecCurrChn: Decodieren 
//--------------------------------------------------------------------------
int DecCurrChn(char *Line)
{   DevIni.nCurrChn = atoi(Line);   return(true);   }
//--------------------------------------------------------------------------
// DecAmpChn: Decodieren 
//--------------------------------------------------------------------------
int DecAmpChn(char *Line)
{   DevIni.nAmpChn = atoi(Line);   return(true);   }
//--------------------------------------------------------------------------
// DecAmpActive: Decodieren 
//--------------------------------------------------------------------------
int DecAmpActive(char *Line)
{   DevIni.nAmpActive = atoi(Line);   return(true);   }
//--------------------------------------------------------------------------
// DecSwIz: Decodieren 
//--------------------------------------------------------------------------
int DecSwIz(char *Line)
{   DevIni.nSwIz = atoi(Line);   return(true);   }
//--------------------------------------------------------------------------
// DecSwPg: Decodieren 
//--------------------------------------------------------------------------
int DecSwPg(char *Line)
{   DevIni.nSwPotGal = atoi(Line);   return(true);   }

//--------------------------------------------------------------------------
// DecPotInverted: Decodieren 
//--------------------------------------------------------------------------
int DecPotInverted(char *Line)
{   DevIni.nPotInverted = atoi(Line);   return(true);   }

//--------------------------------------------------------------------------
// DecOPotInv: Decodieren 
//--------------------------------------------------------------------------
int DecOPotInv(char *Line)
{   DevIni.nOPotInv = atoi(Line);   return(true);   }

//--------------------------------------------------------------------------
// DecOGalInv: Decodieren 
//--------------------------------------------------------------------------
int DecOGalInv(char *Line)
{   DevIni.nOGalInv = atof(Line);   return(true);   }

//--------------------------------------------------------------------------
// DecGalVarVal: Decodieren 
//--------------------------------------------------------------------------
int DecGalVarVal(char *Line)
{   DevIni.dbGalVar = atof(Line);   return(true);   }

//--------------------------------------------------------------------------
// DecUnChn: Decodieren 
//--------------------------------------------------------------------------
int DecUnChn(char *Line)
{   DevIni.nUnChn = atoi(Line);   return(true);   }

//--------------------------------------------------------------------------
// DecInChn: Decodieren 
//--------------------------------------------------------------------------
int DecInChn(char *Line)
{   DevIni.nInChn  = atoi(Line);   return(true);   }

//--------------------------------------------------------------------------
// DecInActive: Decodieren 
//--------------------------------------------------------------------------
int DecInActive(char *Line)
{   DevIni.nNoiseActive = atoi(Line);   return(true);   }

//--------------------------------------------------------------------------
// DecLpcCalC0: Decodieren 
//--------------------------------------------------------------------------
int DecLpcCalC0(char *Line)
{   DevIni.dbLpcCal0 = atof(Line);   return(true);   }

//--------------------------------------------------------------------------
// DecLpcCalC1: Decodieren 
//--------------------------------------------------------------------------
int DecLpcCalC1(char *Line)
{   DevIni.dbLpcCal1 = atoi(Line);   return(true);   }

//--------------------------------------------------------------------------
// DecLpcCalC2: Decodieren 
//--------------------------------------------------------------------------
int DecLpcCalC2(char *Line)
{   DevIni.dbLpcCal2 = atof(Line);   return(true);   }

//--------------------------------------------------------------------------
// DecLpcCalC3: Decodieren 
//--------------------------------------------------------------------------
int DecLpcCalC3(char *Line)
{   DevIni.dbLpcCal3 = atof(Line);   return(true);   }

//--------------------------------------------------------------------------
// DecLpcCalC4: Decodieren 
//--------------------------------------------------------------------------
int DecLpcCalC4(char *Line)
{   DevIni.dbLpcCal4 = atof(Line);   return(true);   }

//--------------------------------------------------------------------------
// DecLpcCalC5: Decodieren 
//--------------------------------------------------------------------------
int DecLpcCalC5(char *Line)
{   DevIni.dbLpcCal5 = atof(Line);   return(true);   }

//--------------------------------------------------------------------------
// DecLpcCalC6: Decodieren 
//--------------------------------------------------------------------------
int DecLpcCalC6(char *Line)
{   DevIni.dbLpcCal6 = atof(Line);   return(true);   }

//--------------------------------------------------------------------------
// DecLpcCalC7: Decodieren 
//--------------------------------------------------------------------------
int DecLpcCalC7(char *Line)
{   DevIni.dbLpcCal7 = atof(Line);   return(true);   }

//--------------------------------------------------------------------------
// DecInstBoard: Decodieren 
//--------------------------------------------------------------------------
int DecInstBoard(char *Line)
{   DevIni.nInstBoard = atoi(Line);   return(true);   }

//--------------------------------------------------------------------------
// DecSRateId: Decodieren 
//--------------------------------------------------------------------------
int DecSRateId(char *Line)
{   DevIni.nSRateIndex = atoi(Line);   return(true);   }

//--------------------------------------------------------------------------
// DecAvValue: Decodieren 
//--------------------------------------------------------------------------
int DecAvValue(char *Line)
{   DevIni.nAvValue = atoi(Line);   return(true);   }

/*-------------------------------------------------------------------------------
Struktur Initialisieren
-------------------------------------------------------------------------------*/
void InitDevIni()
{
    
    DevIni.nDevIndex = 50;        // Geräteindex
    DevIni.nPotRev = 1;           // Hardware Rev
    DevIni.dbPotVar = 1.0;        // Variabler Faktor für das Anzeigepotential
    DevIni.dbScanVar = 1.0;       // Variabler Faktor für das Scannerpotential
    DevIni.nPotChn = 0;           // Messkanal Potential
    DevIni.nCurrChn = 1;          // Messkanal Strom
    DevIni.nAmpChn = 3;           // Messkanal Verstärker
    DevIni.nAmpActive = 0;        // Stromverstärker aktiv
    DevIni.nSwIz = 4;             // Schalter OCP/Izelle
    DevIni.nSwPotGal = 5;         // Schalter Pot/Gal
    DevIni.nPotInverted = 1;      // Potentialanzeige invertiert
    DevIni.nOPotInv = 1;          // Scanner Potential invertiert
    DevIni.nOGalInv = 1;          // Scanner Galvanostat invertiert
    DevIni.dbGalVar = 1.0;        // Variabler Faktor für Galvanostat
    DevIni.nUnChn = 4;            // Messkanal UNoise
    DevIni.nInChn = 5;            // Messkanal INoise
    DevIni.nNoiseActive = 0;      // Noisemessung aktiv
    DevIni.dbLpcCal0 = 1.0;       // 1. Faktor für LpcKalibrierung
    DevIni.dbLpcCal1 = 1.0;       // 2. Faktor für LpcKalibrierung
    DevIni.dbLpcCal2 = 1.0;       // 3. Faktor für LpcKalibrierung
    DevIni.dbLpcCal3 = 1.0;       // 4. Faktor für LpcKalibrierung
    DevIni.dbLpcCal4 = 1.0;       // 5. Faktor für LpcKalibrierung
    DevIni.dbLpcCal5 = 1.0;       // 6. Faktor für LpcKalibrierung
    DevIni.dbLpcCal6 = 1.0;       // 7. Faktor für LpcKalibrierung
    DevIni.dbLpcCal7 = 1.0;       // 8. Faktor für LpcKalibrierung
    DevIni.nInstBoard = 4;        // Installierte Messkarte
    DevIni.nSRateIndex = 3;       // Index Samplerate
    DevIni.nAvValue = 5;          // Average Value    
    
}

//--------------------------------------------------------------------------
//  #DI#  DevID-Request, Host fragt die Geräteeinstellungen ab
//--------------------------------------------------------------------------
int SendDevFile(char *Line)
{

    OpenDevIni();                  
   
    
    sprintf(HostIf.strTempBuf, "%c#DI#%s=%d#",STX, DevIdKey[0],DevIni.nDevIndex);
    sprintf(STemp, "%s=%d#", DevIdKey[1],DevIni.nPotRev);
    strcat(HostIf.strTempBuf, STemp);
    
    sprintf(STemp, "%s=%f#", DevIdKey[2],DevIni.dbPotVar);
    strcat(HostIf.strTempBuf, STemp);
    sprintf(STemp, "%s=%f#", DevIdKey[3],DevIni.dbScanVar);
    strcat(HostIf.strTempBuf, STemp);
    
    sprintf(STemp, "%s=%d#", DevIdKey[4],DevIni.nPotChn);
    strcat(HostIf.strTempBuf, STemp);
    sprintf(STemp, "%s=%d#", DevIdKey[5],DevIni.nCurrChn);
    strcat(HostIf.strTempBuf, STemp);
    sprintf(STemp, "%s=%d#", DevIdKey[6],DevIni.nAmpChn);
    strcat(HostIf.strTempBuf, STemp);
    sprintf(STemp, "%s=%d#", DevIdKey[7],DevIni.nAmpActive);
    strcat(HostIf.strTempBuf, STemp);
    sprintf(STemp, "%s=%d#", DevIdKey[8],DevIni.nSwIz);
    strcat(HostIf.strTempBuf, STemp);
    sprintf(STemp, "%s=%d#", DevIdKey[9],DevIni.nSwPotGal);
    strcat(HostIf.strTempBuf, STemp);
    sprintf(STemp, "%s=%d#", DevIdKey[10],DevIni.nPotInverted);
    strcat(HostIf.strTempBuf, STemp);
    sprintf(STemp, "%s=%d#", DevIdKey[11],DevIni.nOPotInv);
    strcat(HostIf.strTempBuf, STemp);
    sprintf(STemp, "%s=%d#", DevIdKey[12],DevIni.nOGalInv);
    strcat(HostIf.strTempBuf, STemp);
    sprintf(STemp, "%s=%f#", DevIdKey[13],DevIni.dbGalVar);
    strcat(HostIf.strTempBuf, STemp);
    sprintf(STemp, "%s=%d#", DevIdKey[14],DevIni.nUnChn);
    strcat(HostIf.strTempBuf, STemp);
    sprintf(STemp, "%s=%d#", DevIdKey[15],DevIni.nInChn);
    strcat(HostIf.strTempBuf, STemp);
    sprintf(STemp, "%s=%d#", DevIdKey[16],DevIni.nNoiseActive);
    strcat(HostIf.strTempBuf, STemp);

    sprintf(STemp, "%s=%f#", DevIdKey[17],DevIni.dbLpcCal0);
    strcat(HostIf.strTempBuf, STemp);
    sprintf(STemp, "%s=%f#", DevIdKey[18],DevIni.dbLpcCal1);
    strcat(HostIf.strTempBuf, STemp);
    sprintf(STemp, "%s=%f#", DevIdKey[19],DevIni.dbLpcCal2);
    strcat(HostIf.strTempBuf, STemp);
    sprintf(STemp, "%s=%f#", DevIdKey[20],DevIni.dbLpcCal3);
    strcat(HostIf.strTempBuf, STemp);
    sprintf(STemp, "%s=%f#", DevIdKey[21],DevIni.dbLpcCal4);
    strcat(HostIf.strTempBuf, STemp);
    sprintf(STemp, "%s=%f#", DevIdKey[22],DevIni.dbLpcCal5);
    strcat(HostIf.strTempBuf, STemp);
    sprintf(STemp, "%s=%f#", DevIdKey[23],DevIni.dbLpcCal6);
    strcat(HostIf.strTempBuf, STemp);
    sprintf(STemp, "%s=%f#", DevIdKey[24],DevIni.dbLpcCal7);
    strcat(HostIf.strTempBuf, STemp);

    sprintf(STemp, "%s=%d#", DevIdKey[25],DevIni.nInstBoard);
    strcat(HostIf.strTempBuf, STemp);
    sprintf(STemp, "%s=%d#", DevIdKey[26],DevIni.nSRateIndex);
    strcat(HostIf.strTempBuf, STemp);
    sprintf(STemp, "%s=%d#%c\r\n", DevIdKey[27],DevIni.nAvValue, ETX);
    strcat(HostIf.strTempBuf, STemp);

    SendIdTel();

    return(true);
}

//--------------------------------------------------------------------------
//  #GD#  DevID-Request, Host sendet die Geräteeinstellungen 
//--------------------------------------------------------------------------
int GetDevFile(char *Line)
{

    clSdCard.WriteFile(FileNames.DevIdFileName, Line);
    OpenDevIni();
    return(true);

}
/*-------------------------------------------------------------------------------
Parameter Schreiben
-------------------------------------------------------------------------------*/
int WriteDevFile()
{
    int Ret,i;

    if(g_SdInitSuccess == false)    // wenn SD Karte nicht vorhanden, retour
    {
        return(false);
    }
    
    Ret = clSdCard.OpenFile(FileNames.DevIdFileName, FileNames.FileWriteMode);
    
    if(Ret == false)
        return(false);  // öffnen der Datei hat nicht geklappt


    i = 0;
    sprintf(clSdCard.cSdLine, "%s=%d\r\n",DevIdKey[i],DevIni.nDevIndex);
    clSdCard.WriteLine();
    i++;
    sprintf(clSdCard.cSdLine, "%s=%d\r\n",DevIdKey[i],DevIni.nPotRev);
    clSdCard.WriteLine();
    i++;
    sprintf(clSdCard.cSdLine, "%s=%f\r\n",DevIdKey[i],DevIni.dbPotVar);
    clSdCard.WriteLine();
    i++;
    sprintf(clSdCard.cSdLine, "%s=%f\r\n",DevIdKey[i],DevIni.dbScanVar);
    clSdCard.WriteLine();
    i++;
    sprintf(clSdCard.cSdLine, "%s=%d\r\n",DevIdKey[i],DevIni.nPotChn);
    clSdCard.WriteLine();
    i++;
    sprintf(clSdCard.cSdLine, "%s=%d\r\n",DevIdKey[i],DevIni.nCurrChn);
    clSdCard.WriteLine();
    i++;
    sprintf(clSdCard.cSdLine, "%s=%d\r\n",DevIdKey[i],DevIni.nAmpChn);
    clSdCard.WriteLine();
    i++;
    sprintf(clSdCard.cSdLine, "%s=%d\r\n",DevIdKey[i],DevIni.nAmpActive);
    clSdCard.WriteLine();
    i++;
    sprintf(clSdCard.cSdLine, "%s=%d\r\n",DevIdKey[i],DevIni.nSwIz);
    clSdCard.WriteLine();
    i++;
    sprintf(clSdCard.cSdLine, "%s=%d\r\n",DevIdKey[i],DevIni.nSwPotGal);
    clSdCard.WriteLine();
    i++;
    sprintf(clSdCard.cSdLine, "%s=%d\r\n",DevIdKey[i],DevIni.nPotInverted);
    clSdCard.WriteLine();
    i++;
    sprintf(clSdCard.cSdLine, "%s=%d\r\n",DevIdKey[i],DevIni.nOPotInv);
    clSdCard.WriteLine();
    i++;
    sprintf(clSdCard.cSdLine, "%s=%d\r\n",DevIdKey[i],DevIni.nOGalInv);
    clSdCard.WriteLine();
    i++;
    sprintf(clSdCard.cSdLine, "%s=%f\r\n",DevIdKey[i],DevIni.dbGalVar);
    clSdCard.WriteLine();
    i++;
    sprintf(clSdCard.cSdLine, "%s=%d\r\n",DevIdKey[i],DevIni.nUnChn);
    clSdCard.WriteLine();
    i++;
    sprintf(clSdCard.cSdLine, "%s=%d\r\n",DevIdKey[i],DevIni.nInChn);
    clSdCard.WriteLine();
    i++;
    sprintf(clSdCard.cSdLine, "%s=%d\r\n",DevIdKey[i],DevIni.nNoiseActive);
    clSdCard.WriteLine();
    i++;
    sprintf(clSdCard.cSdLine, "%s=%f\r\n",DevIdKey[i],DevIni.dbLpcCal0);
    clSdCard.WriteLine();
    i++;
    sprintf(clSdCard.cSdLine, "%s=%f\r\n",DevIdKey[i],DevIni.dbLpcCal1);
    clSdCard.WriteLine();
    i++;
    sprintf(clSdCard.cSdLine, "%s=%f\r\n",DevIdKey[i],DevIni.dbLpcCal2);
    clSdCard.WriteLine();
    i++;
    sprintf(clSdCard.cSdLine, "%s=%f\r\n",DevIdKey[i],DevIni.dbLpcCal3);
    clSdCard.WriteLine();
    i++;
    sprintf(clSdCard.cSdLine, "%s=%f\r\n",DevIdKey[i],DevIni.dbLpcCal4);
    clSdCard.WriteLine();
    i++;
    sprintf(clSdCard.cSdLine, "%s=%f\r\n",DevIdKey[i],DevIni.dbLpcCal5);
    clSdCard.WriteLine();
    i++;
    sprintf(clSdCard.cSdLine, "%s=%f\r\n",DevIdKey[i],DevIni.dbLpcCal6);
    clSdCard.WriteLine();
    i++;
    sprintf(clSdCard.cSdLine, "%s=%f\r\n",DevIdKey[i],DevIni.dbLpcCal7);
    clSdCard.WriteLine();
    i++;
    sprintf(clSdCard.cSdLine, "%s=%d\r\n",DevIdKey[i],DevIni.nInstBoard);
    clSdCard.WriteLine();
    i++;
    sprintf(clSdCard.cSdLine, "%s=%d\r\n",DevIdKey[i],DevIni.nSRateIndex);
    clSdCard.WriteLine();
    i++;
    sprintf(clSdCard.cSdLine, "%s=%d\r\n",DevIdKey[i],DevIni.nAvValue);
    clSdCard.WriteLine();
    i++;

    clSdCard.CloseFile();
    return(true);
}


