/*-------------------------------------------------------------------------------
Programm Name:  InitMain.C
Version:        1.0
Sprache:        C++
Compiler:       mbed
Autor:          PS
Copyright:      PS
                 

Funktion:       Macht alle notwendigen Initialisierungen
04.08.2016:  Projekt: EcmComFrdm
-------------------------------------------------------------------------------*/
#include "Headers.h"


// Globale Variablen fuer Main

// int g_nMainCounter; 
bool m_fAutoStart;

// bool m_fDoCheckIRange;

// PwmOut PwmTest(PTA0);
bool m_fTimeAlternate;  // wird fuer die Anfrage der Zeit in Sekunden genommen
bool g_fEnableTftIrq;   // wird zur Bearbeitung de TFT Irq's genommen
bool g_fOnDuringInit;

/*-------------------------------------------------------------------------------
Main Init.  
-------------------------------------------------------------------------------*/
int InitMain() 
{

    m_fAutoStart = false;
	g_fDoDioReInit = false;
	m_fTimeAlternate = false;
	g_fOnDuringInit = true;

#ifdef TOUCH_DISPLAY
//	g_fEnableTftIrq = false;
    g_iMethCCActive = false;
   	g_fTimerIsRunning = false;
#endif	
    EcmIni.nAnzChannel = 8;
    MVars.nAnzPot = 1;      // nur 1 Pot. 
	
	InitInterface();
	printf("Init Interface done.\n");
	
    SetTimerInterrupt(1);
	printf("Timer started.\n");
    if (InitGlobals() == true)	// noch kein Zugriff auf die A/D Wandler
    {
		printf("Global Values initialized.\n");
      	g_RCodeStartUp |= 0x01;
    }
    else
		printf("Error on init Global Values. \n");
      	
    if (InitSdFileSystem() == true)    
    {
		printf("SD-Filesystem initialized.\n");
      	g_RCodeStartUp |= 0x02;
    }
    else
		printf("Error on init SD-Filesystem. \n");
    
    if (OpenIni() == true)
    {
		printf("IniFile read sucessful.\n");
       	g_RCodeStartUp |= 0x04;
    }
    else
		printf("Error on open Ini-File. \n");
	
	OpenDevIni();
	printf("DevIniFile read sucessful.\n");
    
    if (InitDio() == true)
    {
		printf("Digital I/O initialized.\n");
    	g_RCodeStartUp |= 0x08;
    }
    else
		printf("Error on init Digital I/O. \n");
    
#ifndef PGU_RPA    
    if (InitMethGlobals() == true)	//  
    {
		printf("Global Method values initialized.\n");
       	g_RCodeStartUp |= 0x10;
    }
    else
		printf("Error on init Global Method values. \n");

    InitAutoStart();   // Autostartdatei lesen 
	printf("Auto-Start initialized.\n");
#endif
#ifdef TOUCH_DISPLAY
    if (InitTftGlobals() == true)	//  2016-03-31  UFa; Initialisierung der TftGlobals Variablen
       	g_RCodeStartUp |= 0x18;
#endif
#ifndef PGU_RPA    
    if (InitFkt() == true)   
    {
		printf("Scanner initialized.\n");
      	g_RCodeStartUp |= 0x20;
    }
    else
		printf("Error on init Scanner. \n");
#endif            
    if (InitDac() == true)
    {
		printf("DAC initialized.\n");
       	g_RCodeStartUp |= 0x40;
    }
    else
		printf("Error on init DAC. \n");
    
#ifdef ADC_24BIT    
    if (InitSpiAd() == true) // Setzt den Mode vom ADC Irq
    {
		printf("24 Bit ADC  initialized.\n");
       	g_RCodeStartUp |= 0x80;
    }
    else
		printf("Error on init 24 Bit ADC. \n");
    
#endif		
//    SwitchRangesOnStart();  //UFa 2017-05-23 -- > IRange.RangeValue[0] wird uad 0 gesetzt;
    
#ifdef TOUCH_DISPLAY    
	DefineTouchInt();		//  2016-03-07  UFa:  Touch Interrupts Definition
	
 	DispInit2Screen();
   

	TftDecodeChannel(1);  	 //  Initialer Aufruf, da Para = 1 

    TftDisp.fMeasureRunning	= false;	// initial, es l�uft keine aktive Messung 	
    TftDisp.fPguTouchActive = true;		// initial, PguTouch ist via TFT bedienbar
       
    g_ToCallScreen = 0;
 	DispMainScreenStatic();  
  	DispMainScreenDynamic();    
#endif

#ifdef ADC_24BIT    
    AdReset();
    InitSpiAd();  // definiert die Irq's, der CallBack ist aber noch nicht scharf
    Ad7739Init(0);		// macht den kompletten Registerinit der ADC's
    printf("Nach Ad7739 Init\n");

	#ifdef PGU_STAND_ALONE
	    SetAdIrq();		// macht den Interrupt scharf
    	DoAdStart();
	#endif    	
#endif	

	g_fOnDuringInit = false;
    return(true);
}

