/*-------------------------------------------------------------------------------
Programm Name: Globals.H
Version:       1.0
Sprache:       C
Compiler:      CrossStudio Ver. 2.0
Autor:         PS
Copyright:     PS
Funktion:      Globale Variablen und externe Methoden

28.10.2012: 

-------------------------------------------------------------------------------*/
/*
Memo: Bei den ersten FRDM Modulen, die bei der Sika stehen, ist die Verdrahtung der Messkanäle so, daß die ersten vier auf dem ersten 
Wandler sind: U=A0:0, I=A0:1, IF=A0:2, IA=A0:3, UR=A1:0 (4), IR=A1:1 (5)

bei der Rev-B ist es wie bei dem LPC, d.h. die Verdrahtung ist alternieren
U=A0:0, I=A1:0, IF=A0:1, IA=A1:1, UR=A0:2 , IR=A1:2 

jetzt ist das Programm auf Rev. B eingestellt, bei Updates bei der Sika ist aufzupassen
09.04.16
*/



// Defines
//------------------------------------
// #define DEBUG   1
// #define IR_DEBUG   1  // speziell für die IR-Kompensation
// #define SIO_DEBUG    1
// #define SINGLE_DEBUG     1

// #define TFT_DEBUG   1

#define ANZ_KEY     34      // Schlüssel für die Inidatei

// #define PGU_TOUCH   1
// #define PGU_OEM_SPI   1

// die beiden folgenden sind z.B. für die Hiltigeräte aber auch grundsätzlich für FRDM RevB und PguMod zusetzten
#define FRDM_REV_D  1


#define DEFAULT_STACK_SIZE 2048


#define HIGH        1
#define LOW         0

#define READ_CHN    0
#define WANDLER     0



// Variable in TCPSocket.cpp im Ordner mbed-dev/features/netsocket
// wird incrementiert, wenn ein Telegramm kommt

extern double m_dbKehrWert;


// Digital In-/ Outs
//-----------------------------------
// LED's 
extern DigitalOut LedRed;         // PTB22
extern DigitalOut LedGreen;     // PTE26
extern DigitalOut LedBlue;       // PTB21

// I/O's für die Messbereichsumschaltung



// I/O's für den D/A Wandler
extern DigitalOut DacSck;
extern DigitalOut DacMosi;
extern DigitalOut DacCs;

// DIO Globals
extern DigitalOut SwR1;
extern DigitalOut SwR2;
extern DigitalOut SwR3;
extern DigitalOut SwR0;



// Makros zum Schreiben des D/A Wandlers
//-----------------------------------
#define DaCsUp()        (GPIOC->PSOR |= 0x00000002)
#define DaCsDown()      (GPIOC->PCOR |= 0x00000002)


#define DaSckUp()       (GPIOB->PSOR |= 0x00080000)
#define DaSckDown()     (GPIOB->PCOR |= 0x00080000)
#define DaMosiUp()      (GPIOB->PSOR |= 0x00040000)
#define DaMosiDown()    (GPIOB->PCOR |= 0x00040000)



#define SW_REV  "1.0.02"

extern int g_fDoDioReInit;



//------------------------------------------------------





/*-------------------------------------------------------------------------------
Variablen für zeitverzögerte Funktionen
-------------------------------------------------------------------------------*/
extern int g_nDelayCounter;
extern int g_nCntSpzFktSwitchIRange;
extern int g_nCntSpzFktSwitchNoiseGain;
extern int g_nCntSpzClearDDS;
extern int g_nCntSpzSwitchMosFet;


extern bool g_fSpzFktSwitchNoiseGain;
extern bool g_fSpzFktSetMosFet;
extern bool g_fSpzFktClearDDS;

extern bool g_fCheckSpecial;
extern int g_nEntPrellCounter;


/*-------------------------------------------------------------------------------
Variablen für die Ini-Datei
-------------------------------------------------------------------------------*/
extern string cfgArray[ANZ_KEY][2];



/*-------------------------------------------------------------------------------
Variablen für die IR-Kompensation
-------------------------------------------------------------------------------*/
extern IR_COMP IrComp;


/*-------------------------------------------------------------------------------
Variablen für Statustelegramm
-------------------------------------------------------------------------------*/
extern bool fSendStatus;



/*-------------------------------------------------------------------------------
Variablen für das Netzwerkhandling
-------------------------------------------------------------------------------*/


/*-------------------------------------------------------------------------------
Variable für das Auslesen der SD Card und Versenden via TCP
-------------------------------------------------------------------------------*/

extern char FName[128];
extern char DName[128];

extern char IoLine[256];

extern DIR *dir;
extern FILE *ifs;

extern char g_sTelEndeContinue[8];
extern char g_sTelEndeFinish[8];
extern bool g_fMwTransferOpen;
extern char g_cFileEndCharacter[2];

/*-------------------------------------------------------------------------------
Strukturen und Pointer
-------------------------------------------------------------------------------*/
extern AD_VAL *AdVal;

// Globale Strukturen
extern WATCH_DOG WDog;
extern MESS_VARIABLES  Mv[ANZ_POT];     // Alles für 2 mal
extern MESS_VARS MVars;
extern START_UP StartUp;
extern FRQ_VALUES FrqValues;
extern NEW_SCAN_RATE NsRate;
extern ECM_INI EcmIni;

extern MESS_PARAMETER MPara;

// extern I_RANGE IRange;



extern UINT32 nScanCount[2];
extern UINT16 nDispCount;
extern UINT8 fSetHold;
extern double LastVal[2];


extern bool m_fChangeMittelValue;
extern bool m_fFallBack;
extern int nFallBackCounter;


// Globale Variablen
extern uint8_t AdcA0V1, AdcA0V2, AdcA0V3;
extern uint8_t AdcA1V1, AdcA1V2, AdcA1V3;
extern uint8_t g_u8AdcStatus[2];
extern uint8_t g_u8ChnStatus[2][8];



extern int nCounter[2];
extern int m_nId, m_nCounter;
extern UINT8 fARead[8], fSendData;
extern unsigned long AdTemp[8];
extern long m_lMittelCount;
extern int m_fIdSend;
extern int MessTimer;
extern int nSumCount;

extern UINT8 g_ReadReg[8];

extern int nGenFktNr[2];  // ist local und wird nur für die Funktionsnummer verwendet

extern uint8_t g_RCodeStartUp;        // RCode der einzelne RCodes beim Start beinhaltet 
extern bool g_fTimerIsRunning;


// Prototypen
// Globale Funktionen

// Funktionen aus Main.c
//------------------------------------
extern int CheckDaAd();
extern int CheckEthInput();
extern int DoReInit();

extern int CheckZustand();
extern int SendIdTel();
extern void LedsOff();
extern int SendAnalogValues();
extern int ReadAllAdChannels();
extern void ChangeConversionTime();
extern int CheckGrundZustand();
extern int CheckRunZustand();
extern void SendStatus(void); 

extern int SendMessungStart();
extern int SendMessungStop();
extern void SendInfo(void); 
extern void ReadAllChannels();




// Funktionen aus Globals.c
//------------------------------------
extern int InitGlobals();
extern void InitAdValues();
extern void short_delay(int n);

extern void SendDataDa();
extern int InitAll();
extern int InitMVars();

// Funktionen aus EthInOut.c
//------------------------------------
extern int CheckForFirstConnection();
extern int WaitForEcmWinRequest();
extern int ReadEthTel();
extern int CheckWait();
extern int DisconnectClient();


// Funktionen aus EcmTel.cpp
//------------------------------------
extern int CheckTel();
extern int DecodeTel();
extern int CloseUdFile();
extern void CalcSendAnzWerte();

// Funktionen aus Dio.cpp
//------------------------------------
extern int ChangeMittelValue();



// Funktionen aus DaMethoden.cpp
//------------------------------------
extern void CalcDa(double SrcVal, UINT8 Chn);


// Funktionen aus CalcScan.cpp
//------------------------------------
extern int SetStartDefault(int Nr);
extern int SetMessungEnde();
extern int SetStartBasics(int Nr);

