/*-------------------------------------------------------------------------------
Programm Name: Globals.C
Version:       1.0
Sprache:       C
Compiler:      CrossStudio Ver. 2.0
Autor:         PS
Copyright:     PS

Funktion:      Globale Variablen

28.10.2012: 

Memo der Registerzuordnung am Beispiel des PTD 
----------------------------------------------
#define GPIOD_PDOR                               GPIO_PDOR_REG(PTD)
#define GPIOD_PSOR                               GPIO_PSOR_REG(PTD)
#define GPIOD_PCOR                               GPIO_PCOR_REG(PTD)
#define GPIOD_PTOR                               GPIO_PTOR_REG(PTD)
#define GPIOD_PDIR                               GPIO_PDIR_REG(PTD)
#define GPIOD_PDDR                               GPIO_PDDR_REG(PTD)

** GPIO - Register Layout Typedef 
typedef struct {
  __IO uint32_t PDOR;                              **< Port Data Output Register, offset: 0x0 
  __O  uint32_t PSOR;                              **< Port Set Output Register, offset: 0x4 
  __O  uint32_t PCOR;                              **< Port Clear Output Register, offset: 0x8 
  __O  uint32_t PTOR;                              **< Port Toggle Output Register, offset: 0xC 
  __I  uint32_t PDIR;                              **< Port Data Input Register, offset: 0x10 
  __IO uint32_t PDDR;                              **< Port Data Direction Register, offset: 0x14
} GPIO_Type, *GPIO_MemMapPtr;

*/

/*-------------------------------------------------------------------------------*/
#include "Headers.h"


// LED's 
DigitalOut LedRed(LED_RED);         // PTB22
DigitalOut LedGreen(LED_GREEN);     // PTE26
DigitalOut LedBlue(LED_BLUE);       // PTB21

// I/O's für die Messbereichsumschaltung



// I/O's für den D/A Wandler
// Aenderungen fuer REV-D, PTC16 und PTC17 werden nicht mehr benutzt
// Aenderungen treffen auf den D/A Wandler zu
// I/O's fuer D/A Wandler 
DigitalOut DacSck(PTB19);
DigitalOut DacMosi(PTB18);
DigitalOut DacCs(PTC1);

// DIO Globals

DigitalOut SwR1(PTD2);
DigitalOut SwR2(PTD3);
DigitalOut SwR3(PTE25);
DigitalOut SwR0(PTE24);



// Variablen, die in Interruptroutinen verwendet werden
int g_fDoDioReInit;

//------------------------------------------------------




double m_dbKehrWert;


uint8_t g_u8AdcStatus[2];
uint8_t g_u8ChnStatus[2][8];

int nCounter[2];
int m_nId, m_nCounter;
UINT8 fARead[8], fSendData;
unsigned long AdTemp[8];
long m_lMittelCount;
int m_fIdSend;
int MessTimer;
int nSumCount;

UINT8 g_ReadReg[8];

bool m_fChangeMittelValue;
bool m_fFallBack;
int nFallBackCounter;

bool g_fSequenzMessung;


/*-------------------------------------------------------------------------------
Variablen für zeitverzögerte Funktionen
-------------------------------------------------------------------------------*/
int g_nDelayCounter;
int g_nCntSpzFktSwitchIRange;
int g_nCntSpzFktSwitchNoiseGain;
int g_nCntSpzClearDDS;
int g_nCntSpzSwitchMosFet;


bool g_fSpzFktSwitchNoiseGain;
bool g_fSpzFktSetMosFet;
bool g_fSpzFktClearDDS;

bool g_fCheckSpecial;
int g_nEntPrellCounter;



/*-------------------------------------------------------------------------------
Variablen für die IR-Kompensation
-------------------------------------------------------------------------------*/
IR_COMP IrComp;



/*-------------------------------------------------------------------------------
Variablen für die SPI Ausgabemasken
-------------------------------------------------------------------------------*/





/*-------------------------------------------------------------------------------
Variablen für das Netzwerkhandling
-------------------------------------------------------------------------------*/

/*-------------------------------------------------------------------------------
Variable für das Auslesen der SD Card und Versenden via TCP
-------------------------------------------------------------------------------*/

char FName[128];
char DName[128];

char IoLine[256];

DIR *dir;
FILE *ifs;

char g_sTelEndeContinue[8];
char g_sTelEndeFinish[8];
bool g_fMwTransferOpen;
char g_cFileEndCharacter[2];

/*-------------------------------------------------------------------------------
Strukturen und Pointer
-------------------------------------------------------------------------------*/
START_UP StartUp;
WATCH_DOG WDog;
MESS_VARIABLES  Mv[ANZ_POT];     // Alles für 2 mal
MESS_VARS MVars;
FRQ_VALUES FrqValues;
NEW_SCAN_RATE NsRate;
ECM_INI EcmIni;

MESS_PARAMETER MPara;
// I_RANGE IRange;

//UINT32 nAnzPulsesUp[2];
//UINT32 nAnzPulsesDown[2];

//float flUpperPot;
//float flLowerPot;


UINT32 nScanCount[2];
UINT16 nDispCount;
UINT8 fSetHold;
double LastVal[2];


int nGenFktNr[2];  // ist local und wird nur für die Funktionsnummer verwendet

uint8_t g_RCodeStartUp;        // RCode der einzelne RCodes beim Start beinhaltet 
bool g_fTimerIsRunning;


/*-------------------------------------------------------------------------------
LED1 umschalten
-------------------------------------------------------------------------------*/
void SLed1()
{
    LedRed = !LedRed;
}
/*-------------------------------------------------------------------------------
Alle vier LEDs ausschalten
-------------------------------------------------------------------------------*/
void LedsOff()
{
    LedRed = 0;
    LedGreen = 0;
    LedBlue = 0;
}
/*-------------------------------------------------------------------------------
Globale Initialisierung
-------------------------------------------------------------------------------*/

int InitGlobals()
{
    
//    InitCnf();
    InitAll();  // ruft die MVars Inits auf 
    InitAdValues();
    
    g_cFileEndCharacter[0] = 0x7D;
    g_cFileEndCharacter[1] = 0x00;
    sprintf(g_sTelEndeContinue,"%c\r\n", ETX);
    sprintf(g_sTelEndeFinish,"}%c\r\n", ETX);
    g_fMwTransferOpen = false;
    
    
    g_nEntPrellCounter = 1000;

    MVars.fSequenzMessung = false;
    
    MVars.nIpsDebug = false;

    MVars.nCurrentPort = 0x00;
    MVars.m_fScan = false;
    HostIf.fStartTel = true;
    
    MVars.m_nSendValues = false;
    MVars.nDestCount = 0;
    MVars.nSendTimer = 0;    
    MVars.nDaTimer = 0;    
    MVars.nMittelTimer = 0;
    MVars.m_fMeasurementFinished = false;
    MVars.m_fFinishMeasurement = false;
    MVars.m_fDoFinishMeasurement = false;
    MVars.FrkValue[0] = 0.;
    MVars.FrkValue[1] = 0.;
    
    g_fCheckSpecial = false;
    g_nCntSpzSwitchMosFet = 0;
    return(true);
}

/*-------------------------------------------------------------------------------
Kurzer Delay
-------------------------------------------------------------------------------*/
void short_delay(int n)
{
   volatile int d;
   for (d=0; d<n*10; d++){}
}
/*-------------------------------------------------------------------------------
Funktion InitAll: Führt alle Initialisierungen durch
-------------------------------------------------------------------------------*/
int InitAll()
{
    InitMVars();
//    InitSioVars();

    return(0);
}
/*-------------------------------------------------------------------------------
Funktion InitMVars: Initialisiert alle Variablen aus der MVars Strúktur
-------------------------------------------------------------------------------*/
int InitMVars()
{
    int i;

    for(i=0;i<ANZ_POT;i++)
        MVars.nMessZustand[i] = 0;

    MVars.fAdReInit = false;
    MVars.m_nSendValues = 0;
    MVars.m_nAnzChnSend = 0;
//    MVars.m_nStoreMwIntervall = 1;
    MVars.SendAnzWerte = 200;
    MVars.m_fCellSwitchOff = true;

    // 1 = Messung laeuft, -1 = Messung wurde beendet,

    for(i=0;i<16;i++)
    {
        MVars.MwChn[i] = i;
        MVars.m_fChnValid[i] = false;
    }

    for(i=0;i<2;i++)
        MVars.SwitchChn[i] = i+4;
    for(i=2;i<4;i++)
        MVars.SwitchChn[i] = i+10;

    for(i=0;i<2;i++)
    {
        MVars.ZInfo[i] = 0;   // ist in Grundstellung
        Mv[i].IAktInVolt = 0.;
    }
    return(0);
}
