/*
-------------------------------------------------------------------------------
Programm Name: CalcScan.c
Version:       1.0                                                    
Sprache:       C                                                      
Compiler:      MBED
Autor:         PS
Copyright:     PS

Funktion:      Steuerfunktionen für den Scanner (LPC1768)

-------------------------------------------------------------------------------*/
#include "Headers.h"

/*-------------------------------------------------------------------------------
Startwerte, die bei allen Startbefehlen gleich sind, auf Default setzten
-------------------------------------------------------------------------------*/
int SetStartBasics(int Nr)
{
    int i;
    
    MVars.m_fDisableStopTel = false;
    MVars.m_fFinishMeasurement = false;
    MVars.m_fDoFinishMeasurement = false;
    for(i=0;i<4;i++)
        MVars.dbAdSum[i] = 0L;
    MVars.nMwMittelCount = 0;
    MVars.m_nSendValues = 2;       // Messdaten kontinuierlich schicken
    MVars.ZInfo[0] = 1;
    MVars.ZInfo[1] = 1;
    MVars.nAktMittelAfter = MVars.nMittelAfter; // nimmt jetzt das voreingstellte Intervall
#ifdef SIO_DEBUG    
    printf("in SetStartBasics nAktMittelAfter: %d \n",MVars.nAktMittelAfter);
#endif    
    if(MVars.nAktMittelAfter < 6)   // bei 1000/500 und 200 Werten
        MVars.nSendAfter = 5;
    else
        MVars.nSendAfter = 50;
    
    if(MVars.nMittelAfter > 50) // wenn nur wenige Werte gesendet werden, genügt es alle 500ms
        MVars.nSendAfter = 500;
    MVars.m_nAnzValue = MVars.SendAnzWerte/2;
    
    
    MVars.nTelLen = 0;    
    
    MVars.fTelStart = true;
    MVars.nSecCounter[Nr] = 1000;
    MVars.m_fSendStatus = true;
    return(true);
}
/*-------------------------------------------------------------------------------
Diverse Startwerte auf Default setzten
-------------------------------------------------------------------------------*/
int SetStartDefault(int Nr)
{
    SetStartBasics(Nr);
    

// gilt für Scan und Pulsmessung gleichermaßen
    MVars.m_fScan = true;

//    MVars.nSecCounter[Nr] = 0;
    

//    printf("MVars.nAktMittelAfter:%d  MVars.nSendAfter: %d \n",MVars.nAktMittelAfter,MVars.nSendAfter);
    return true;
}
/*-------------------------------------------------------------------------------
Messung beenden. Wird von irgend einem globalen Ereignis wie Watchdog oder
Pufferüberlauf aufgerufen. Alles wird zurückgesetzt
-------------------------------------------------------------------------------*/
int SetMessungEnde()
{

    MVars.m_fDisableStopTel = false;
    MVars.nMessZustand[0] = 0;
    MVars.m_fSendStatus = true;
    MVars.m_fMeasurementFinished = false;
//    MVars.m_fMeasurementFinished 
    MVars.nMittelTimer = 0;
    MVars.m_nSendAnz = 0;
    MVars.m_nSendValues = 1;    // sendet Einzelwerte
    MVars.m_fStartTel = 0x01;
    IrComp.fSendInfo = false;
    MVars.m_nAnzValue = 1;
    MVars.nAktMittelAfter = 500;
    MVars.nSendAfter = 500;
    Mv[0].Circuit = 0;
    Mv[1].Circuit = 0;
    IrComp.dbIrAddVoltage = 0.;
    IrComp.dbKorrVoltage = 0.;
    IrComp.fIrInProcess = false;

//    printf("SetMessungEnde\r\n");
    return(true);
}
