/*-------------------------------------------------------------------------------
Programm Name: AdRead.cpp
Version:       1.0
Sprache:       C++
Compiler:      mbed
Autor:         PS
Copyright:     PS
         

Funktion:      Lese-Funktion für den A/D Wandlerzugriff

30.06.2017: 

-------------------------------------------------------------------------------*/
#include "Headers.h"


// Membervariablen, die nur in dieser Datei verwendet werden
uint8_t m_AiMask, m_Rdy0Mask, m_Rdy1Mask, m_RdyStatus[8];

int g_nDelCount;
uint8_t AdcA0V1, AdcA0V2, AdcA0V3;

long g_nChn1Counter = 0;
long g_nChn2Counter = 0;
long g_nFinishCounter = 0;

uint16_t nTempCounter = 0;

int g_Temp1, g_Temp2, g_Temp3, g_Temp4, g_Temp5, g_Temp6;

Converter0 Conv0[2];

uint8_t g_nIRead;

int nStatusCounter = 0;

bool g_fDisableDataRead;

/*----------------- INTERRUPT SERVICE ROUTINES --------------------------*/

void Rdy0Fall() 
{
    __disable_irq();
    g_fRdy0 = true;
    Adc0ReadChn();
    __enable_irq();
}    
    
/*-------------------------------------------------------------------------------
-------------------------------------------------------------------------------*/
void Rdy1Fall() 
{
    __disable_irq();
    g_fRdy1 = true;
    Adc1ReadChn();
    __enable_irq();
}    
/*-------------------------------------------------------------------------------
ReadConverter0: Lesen des ersten A/D Wandlers
-------------------------------------------------------------------------------*/
void ReadConverter0() 
{
    unsigned char ChnStatus;
    
    g_fRdy0 = false;
    if(g_fDisableDataRead == true)
        return;
//    m_Rdy0Status = ReadAdStatusRegister(0); // liest Statusregister von Wandler 0 
//    m_Rdy0Mask = 0x01;
    ChnStatus = Conv0[0].AdPart[3] >> 5;
    if(ChnStatus >= 4)  ChnStatus = 3;
    
    Conv0[0].AdPart[3] = 0x00;
    MVars.dbAdSum[ChnStatus] += Conv0[0].AdComplete;
    MVars.nChnAverage[(int)ChnStatus]++;
    
}    
/*-------------------------------------------------------------------------------
ReadConverter0: Lesen des ersten A/D Wandlers
Der zweite Wandler wird mit den Idexen 4-7 verarbeitet
-------------------------------------------------------------------------------*/
void ReadConverter1() 
{
    unsigned char ChnStatus;
    
    g_fRdy1 = false;
    if(g_fDisableDataRead == true)
        return;
//    m_Rdy0Status = ReadAdStatusRegister(0); // liest Statusregister von Wandler 0 
//    m_Rdy0Mask = 0x01;
    ChnStatus = Conv0[1].AdPart[3] >> 5;
    if(ChnStatus >= 4)  ChnStatus = 3;
    
    Conv0[1].AdPart[3] = 0x00;
    MVars.dbAdSum[ChnStatus *2 + 1] += Conv0[1].AdComplete;
    MVars.nChnAverage[((int)ChnStatus + 4) + 1]++;
    
}    
/*-------------------------------------------------------------------------------
    CheckAnalogIn: Liest die Daten von den Wandlern
-------------------------------------------------------------------------------*/
int CheckAnalogIn()
{
    if(g_fRdy0 == true) 
        ReadConverter0();
    if(g_fRdy1 == true) 
        ReadConverter1();
    return(true);
}

/*-------------------------------------------------------------------------------
    CheckDaAd: Schreibt zum AD und liest den AD
-------------------------------------------------------------------------------*/
int CheckDaAd()
{
    int i,Ret;
    
//     ReadAllChannels(); wird schon im Main aufgerufen
// In Grundstellung ist nAktMittelAfter=500, d.h. es wird über eine halbe Sekunde gemittelt    
// Im Messmode ist nAktMittelAfter auf einen Wert von z.B. 10 bei 100 Werten pro Sekunde
    Ret = CalculateAdBaseValues();
    if(Ret == false)  // nicht alle Felder waren mit Werten gefüllt
    {
        g_nChn1Counter++;
        g_nChn2Counter++;
        if(g_nChn1Counter > 10)
        {
            Ad7739Stop(); // Erst mal stoppen, damit noch ein weiterer Zugriff passiert
            Ad7739Start(0, 0,1); // neu starten
            g_nChn1Counter = 0;
            if(g_nChn2Counter >= 100 ) // hat 10 Mal versucht neu anzustossen
            {
                sprintf(HostIf.strErrorBuf,"%c#ER#A/D-Converter did not answer. 10 times restart without access %c\r\n", STX, ETX); // 
                HostIf.fSendError = true;
            }
                
        }
        return(false);
    }
    else
    {
        g_nChn1Counter = 0;
        g_nChn2Counter = 0;
    }
    
    g_nChn1Counter = 0;
//    MVars.dbAdResult[g_nUChn[0]] = MVars.dbAdResult[g_nUChn[0]]; //  - IrComp.dbKorrVoltage;
//    CheckLimitValues();

    SendAnalogValues();
    
    MVars.nMwMittelCount = 0;
    return(true);
}

/*-------------------------------------------------------------------------------
-------------------------------------------------------------------------------*/
int AdReadChannels(uint8_t Chn, uint8_t Wandler, uint8_t MitStatus)
{
// ab hier ist der gewandelte Wert einzulesen
// #define AD7739_READ_OP(addr)     (0x40 | addr)        #define AD7739_CHANNEL(0x08, 0...3) (addr | ch)   #define AD7739_ADDR_C_DATA 0x08
//    Ad7739OutWrite(AD7739_READ_OP(AD7739_CHANNEL(AD7739_ADDR_C_DATA, Chn)),Wandler);  //0x48, die 0 legt die CS0 auf low

//    for(g_TempDelay = 0;g_TempDelay < 2; g_TempDelay++);
    AdInRead(Wandler);
    m_RdyStatus[Chn] = g_AReadTemp;
    AdInRead(Wandler);
    AdcA0V1 = g_AReadTemp;
    AdInRead(Wandler);
    AdcA0V2 = g_AReadTemp;
    AdInRead(Wandler);
    AdcA0V3 = g_AReadTemp;
    return(true);
}
/*-------------------------------------------------------------------------------
Liest zuerst das Statusbyte und dann die Daten, welche in die Union Struktur gelesen werden
-------------------------------------------------------------------------------*/
int Adc0ReadChn()
{
    AdInRead(0);
    Conv0[0].AdPart[3] = g_AReadTemp;
    AdInRead(0);
    Conv0[0].AdPart[2] = g_AReadTemp;
    AdInRead(0);
    Conv0[0].AdPart[1] = g_AReadTemp;
    AdInRead(0);
    Conv0[0].AdPart[0] = g_AReadTemp;
    return(true);
}
/*-------------------------------------------------------------------------------
Liest zuerst das Statusbyte und dann die Daten, welche in die Union Struktur gelesen werden
-------------------------------------------------------------------------------*/
int Adc1ReadChn()
{
    AdInRead(1);
    Conv0[1].AdPart[3] = g_AReadTemp;
    AdInRead(1);
    Conv0[1].AdPart[2] = g_AReadTemp;
    AdInRead(1);
    Conv0[1].AdPart[1] = g_AReadTemp;
    AdInRead(1);
    Conv0[1].AdPart[0] = g_AReadTemp;
    return(true);
}

/*-------------------------------------------------------------------------------
//Liest das vorher selektierte Register des ersten A/D Wandler
-------------------------------------------------------------------------------*/
void AdInRead(int Wandler)
{
//    core_util_critical_section_enter();
    int i;
    
    m_AiMask = 0x80;
    g_AReadTemp = 0x00;
    
    AdMosiDown(); // muss unten sein, da sonst der Continous Mode gestoppt werden kann
    AdSckUp();
    
    if(Wandler == 0)
    {
        Ad1CsUp();
        Ad0CsDown();
    }
    else
    {
        Ad0CsUp();
        Ad1CsDown();
    }
    for(g_TempDelay = 0;g_TempDelay < 2; g_TempDelay++);
    for(i=0;i<8;i++)
    {
        AdSckDown();
        for(g_TempDelay = 0;g_TempDelay < 2; g_TempDelay++);
        if(AdIsMisoUp()) 
            g_AReadTemp |= m_AiMask;
        AdSckUp();
        for(g_TempDelay = 0;g_TempDelay < 2; g_TempDelay++);
        m_AiMask = (m_AiMask>>1);
    }
    
    Ad0CsUp();
    Ad1CsUp();
}

