/*-------------------------------------------------------------------------------
Programm Name: AdMember.C
Version:       1.0
Sprache:       C
Compiler:      CrossStudio Ver. 2.0
Autor:         PS
Copyright:     PS
         

Funktion:      Member-Funktion für den A/D Wandlerzugriff

28.10.2012: 

-------------------------------------------------------------------------------*/
#include "Headers.h"

// uint8_t Ch1[8], Ch2[8];

extern uint8_t ReadAd0In(int n);
extern uint8_t ReadAd1In(int n);


/*-------------------------------------------------------------------------------
Liest das IO Register beider AD's
-------------------------------------------------------------------------------*/
uint8_t ReadAdIoPortRegister(uint8_t Wandler)
{
    Ad7739OutWrite(AD7739_READ_OP(AD7739_ADDR_IO), Wandler);  // 0x41 lesen des I/O Portregisters
    {
        AdInRead(Wandler);
        return(g_AReadTemp);
    }
}
uint8_t ReadAdRevisionRegister(uint8_t Wandler)
{
    Ad7739OutWrite(AD7739_READ_OP(AD7739_ADDR_REV), Wandler);  // 0x42
    {
        AdInRead(Wandler);
        return(g_AReadTemp);
    }
}
uint8_t ReadAdTestRegister(uint8_t Wandler)
{
    Ad7739OutWrite(AD7739_READ_OP(AD7739_ADDR_TEST), Wandler);  // 0x43
    ReadAd0Ad1In(3);
    return(true);
}
uint8_t ReadAdStatusRegister(uint8_t Wandler) // wird von Main aufgerufen
{
    Ad7739OutWrite(AD7739_READ_OP(AD7739_ADDR_STATUS), Wandler);  // 0x44
    {
        AdInRead(Wandler);
        return(g_AReadTemp);
    }
}    
uint8_t ReadAdCheckSumRegister(uint8_t Wandler)
{
    Ad7739OutWrite(AD7739_READ_OP(AD7739_ADDR_CHKSUM), Wandler);  // 0x45
    ReadAd0Ad1In(2);
    return(true);
}
uint8_t ReadAdZeroScaleRegister(uint8_t Wandler)
{
    Ad7739OutWrite(AD7739_READ_OP(AD7739_ADDR_ZS_CAL), Wandler);  // 0x46
    ReadAd0Ad1In(3);
    return(true);
}
uint8_t ReadAdFullScaleRegister(uint8_t Wandler)
{
    Ad7739OutWrite(AD7739_READ_OP(AD7739_ADDR_FS_CAL), Wandler);  // 0x47
    ReadAd0Ad1In(3);
    return(true);
}
uint8_t ReadAdChnZeroScaleRegister(uint8_t Wandler)
{
  int i;

    for(i = 0; i < 4; i++)
    {
        Ad7739OutWrite(AD7739_READ_OP(AD7739_ADDR_C_ZS | i), 0);  // 0x50-57
        ReadAd0In(3);
        Ad7739OutWrite(AD7739_READ_OP(AD7739_ADDR_C_ZS | i), 1);  // 0x50-57
        ReadAd1In(3);
#ifdef SINGLE_DEBUG    
    printf("Wandler 1: %02X %02X %02X\n",g_ReadReg[0], g_ReadReg[1], g_ReadReg[2]);  // Parameter ist egal, liest sowieso beide
    printf("Wandler 2: %02X %02X %02X\n",g_ReadReg[4], g_ReadReg[5], g_ReadReg[6]);  // Parameter ist egal, liest sowieso beide
#endif    
    }
    return(true);
}
uint8_t ReadAdChnFullScaleRegister(uint8_t Wandler)
{
  int i;

    for(i = 0; i < 8; i++)
    {
        Ad7739OutWrite(AD7739_READ_OP(AD7739_ADDR_C_FS | i), Wandler);  // 0x58 - 5F
        ReadAd0Ad1In(3);
    }
    return(true);
}

uint8_t ReadAdChnStatusRegister(uint8_t Chn, uint8_t Wandler)
{
    Ad7739OutWrite(AD7739_READ_OP(AD7739_CHANNEL(AD7739_ADDR_C_STAT, Chn)), Wandler);  // 0x60 - 67
    {
        AdInRead(Wandler);
        return(g_AReadTemp);
    }
}
uint8_t ReadAdChnSetupRegister(uint8_t Wandler)
{
  int i;

    for(i = 0; i < 8; i++)
    {
        Ad7739OutWrite(AD7739_READ_OP(AD7739_ADDR_C_SET | i), Wandler);  // 0x68 - 6F
        ReadAd0Ad1In(1);
    }
    return(true);
}
uint8_t ReadAdConvTimeRegister(uint8_t Wandler)
{
  int i;

    for(i = 0; i < 8; i++)
    {
        Ad7739OutWrite(AD7739_READ_OP(AD7739_ADDR_C_CT | i), Wandler);  // 0x70 - 77
        ReadAd0Ad1In(1);
    }
    return(true);
}
uint8_t ReadAdChnModeRegister(uint8_t Wandler)
{
    Ad7739OutWrite(AD7739_READ_OP(AD7739_ADDR_MODE), Wandler);  // 0x70 - 77
    ReadAd0Ad1In(1);
    return(true);
}

uint8_t ReadAd0In(int n)
{
    int i;

    for(i=0;i<n;i++)
    {
        AdInRead(0);  // 
        g_ReadReg[i] = g_AReadTemp;
    }
    return(true);
}
uint8_t ReadAd1In(int n)
{
  int i;

  for(i=0;i<n;i++)
    {
        AdInRead(1);  // 
        g_ReadReg[i+4] = g_AReadTemp;
    }
    return(true);
}


uint8_t ReadAd0Ad1In(int n)
{
  int i;

    for(i=0;i<n;i++)
    {
        AdInRead(0);  // 
        g_ReadReg[i] = g_AReadTemp;
    }
    for(i=0;i<n;i++)
    {
        AdInRead(1);  // 
        g_ReadReg[i+4] = g_AReadTemp;
    }
    return(true);
}