/*-------------------------------------------------------------------------------
Programm Name: AdGlobals.h
Version:       1.0
Sprache:       C++
Compiler:      mbed
Autor:         PS
Copyright:     PS
         

Funktion:      Globale Variablen für den A/D Wandlerzugriff

30.06.2017: 

-------------------------------------------------------------------------------*/

/*
#define _nop_() 
( 
  asm nop
)
*/

// Makros zum lesen des A/D Wandlers
//-----------------------------------
#define Ad0CsUp()       (GPIOB->PSOR |= 0x00000008) // PTB3
#define Ad0CsDown()     (GPIOB->PCOR |= 0x00000008)
#define Ad1CsUp()       (GPIOC->PSOR |= 0x00000100) // PTC8
#define Ad1CsDown()     (GPIOC->PCOR |= 0x00000100)



#define AdSckUp()       (GPIOC->PSOR |= 0x00000400) // PTC10
#define AdSckDown()     (GPIOC->PCOR |= 0x00000400)
#define AdMosiUp()      (GPIOB->PSOR |= 0x00000800) // PTB11
#define AdMosiDown()    (GPIOB->PCOR |= 0x00000800)

#define AdIsMisoUp()    (GPIOC->PDIR & 0x000000800) // PTC11

// Rdy ist der Interrupt von AD7739 
#define Ad0IsRdyUp()    (GPIOB->PDIR & 0x000000400) // PTB10

#define Ad1IsRdyUp()    (GPIOC->PDIR & 0x000000200) // PTC9




// I/O's für den A/D Wandler
//-------------------------------------
extern DigitalOut AdcSck;
extern DigitalIn AdcMiso;
extern DigitalOut AdcMosi;
extern InterruptIn AdcRdy0;
extern InterruptIn AdcRdy1;

extern DigitalIn AdcReset;

extern DigitalOut Adc0Cs;
extern DigitalOut Adc1Cs;



// Globale Variablen
//-------------------------------------
extern uint8_t g_TempDelay;
extern uint8_t g_AReadTemp;
extern uint8_t g_nAdResultCount;


extern AD_VAL *AdVal;
extern UINT8 g_fARead[8];
extern uint8_t g_nAdSetPos, g_nAdGetPos;
extern int g_nAdCount;
extern UINT32 m_AdTemp[8];


extern bool g_fAdConversion; 
extern bool g_fRdy0, g_fRdy1;

// extern uint8_t m_AiMask, m_Rdy0Mask, m_Rdy1Mask, m_Rdy0Status, m_Rdy1Status;


// Funktionen aus AdCalculations.c
//-------------------------------------
extern int CalculateAdBaseValues();
extern int CheckLimitValues();
extern void InitBaseInputArray();



// Funktionen aus AdInit.c
//-------------------------------------
extern int InitSpiAd(void);
extern int AdIsRdyUp(int Chn);
extern void Ad7739Init(int EcmWinCall);   // EcmWinCall == 1, wenn Aufruf durch EcmWin
extern void SetAdConversionTime();
extern void InitAdValues();
extern int ConnectIrq(void);
extern void AdReset();
extern void DoAdReset();


// Funktionen aus AdRead.cpp
//------------------------------------
extern void Rdy0Fall();
extern void Rdy1Fall();
extern int AdReadChannels(uint8_t Chn, uint8_t Wandler, uint8_t MitStatus);
extern void AdInRead(int Chn);


// Funktionen aus AdGlobals.cpp
//------------------------------------
extern void Ad7739CommonWrite(uint8_t b);
extern void Ad7739OutWrite(uint8_t b, int Wandler);
extern void Ad7739Start(uint8_t Chn, uint8_t Wandler, uint8_t Mode);
extern void Ad7739CommonStart(uint8_t No, uint8_t Mode);
extern void Ad7739Stop(void);


// Funktionen aus AdMember.c
//------------------------------------
extern uint8_t ReadAdIoPortRegister(uint8_t Wandler);
extern uint8_t ReadAdRevisionRegister(uint8_t Wandler);
extern uint8_t ReadAdTestRegister(uint8_t Wandler);
extern uint8_t ReadAdStatusRegister(uint8_t Wandler);
extern uint8_t ReadAdCheckSumRegister(uint8_t Wandler);
extern uint8_t ReadAdZeroScaleRegister(uint8_t Wandler);
extern uint8_t ReadAdFullScaleRegister(uint8_t Wandler);
extern uint8_t ReadAdChnZeroScaleRegister(uint8_t Wandler);
extern uint8_t ReadAdChnFullScaleRegister(uint8_t Wandler);
extern uint8_t ReadAdChnStatusRegister(uint8_t Chn, uint8_t Wandler);
extern uint8_t ReadAdChnSetupRegister(uint8_t Wandler);
extern uint8_t ReadAdConvTimeRegister(uint8_t Wandler);
extern uint8_t ReadAdChnModeRegister(uint8_t Wandler);
extern uint8_t ReadAd0Ad1In(int n);








