/*-------------------------------------------------------------------------------
Programm Name: AdCalculations.C
Version:       1.0
Sprache:       C++
Compiler:      mbed Studio
Autor:         PS/UF
Copyright:     IPS
         

Funktion:      Basiskalkulationen für die Umrechnung der Werte von A/D Wandler

16.06.2017 
Neu angelegt um die Funktionen in Main zu entzerren
-------------------------------------------------------------------------------*/
#include "Headers.h"

/*-------------------------------------------------------------------------------
File interne Membervariablen
-------------------------------------------------------------------------------*/


/*-------------------------------------------------------------------------------
CalculateAdBaseValues: macht die Basisumrechnungen der vom A/D Wandler gelieferten 
Werte. Erst mitteln, dann um den Nullpunkt verschieben, dann Skalieren
-------------------------------------------------------------------------------*/
int CalculateAdBaseValues()
{
    int i;
    
    for(i=0;i<8;i++)
    {
        if(MVars.m_fChnValid[i] == true)
        {
            if(MVars.nChnAverage[i] > 0)
            {
                if( MVars.dbAdSum[i] == 0.0)
                {
                    InitBaseInputArray();
                    printf("No Values, dbAdSum = 0.0\r\n");
                    return(false);
                }
                MVars.dbAdResult[i] = MVars.dbAdSum[i] / (double)MVars.nChnAverage[i];
                MVars.dbAdResult[i] -= 8388607.;
                MVars.dbAdResult[i] *= EcmIni.dbUScale[i];  // Potential
                MVars.dbAdResult[i] += EcmIni.dbUOffset[i]; // Offsetkorrektur für das Potential
                MVars.dbAdResult[i] += 8388607.;
            }
            else
            {
                InitBaseInputArray();
                printf("No Values, ChnAverage = 0\r\n");
                return(false);
            }
        }
        MVars.dbAdSum[i] = 0.0;
        MVars.nChnAverage[i] = 0;
    }            
    InitBaseInputArray();
    return(true);
}
/*-------------------------------------------------------------------------------
InitBaseInputArray: setzt die Variablen für die Messdaten, welche im Interrupt gelesen 
werden, auf Null
-------------------------------------------------------------------------------*/
void InitBaseInputArray()
{
    int j;
    
    for(j=0;j<8;j++)
    {
        MVars.dbAdSum[j] = 0.0;
        MVars.nChnAverage[j] = 0;
    }
}

