/*-------------------------------------------------------------------------------------------------------------
Program Name:   SDCard.h
Version:        1.0
Sprache:        C++
Compiler:       mbed
Autors:         UFa/PS

Funktion:       Lesen und Schreiben der SD-Card

History: 
2018-02-02 UFa: Erstellung
 
 --------------------------------------------------------------------------------------------------------------*/
#ifndef SDCARD_H_
#define SDCARD_H_

class StorageCard 
{
    private:

    public:

    int Init(); 
    int OpenFile(char *FName, char *OpenMode);
    int OpenHeaderFile(char *FName, char *OpenMode);
    int ReadLine(char *Dest, int MaxLen);
    int WriteLine();
    int WriteHeaderLine();
    int CloseFile(); 
    int CloseHeaderFile(); 
    int RemoveFile(char *FileName);   // Datei löschen
 
    int ReadFile(char *fName, char *DestBuf, int MaxLen);
    int WriteFile(char *fName, char *SrcBuf);
    int AppendSdValueToLine();

	int OpenAutoFile(char *FName, char *OpenMode);
    int ReadAutoLine(char *Dest, int MaxLen);
    int WriteAutoLine();
    int CloseAutoFile();

	int OpenMwAutoFile(char *FName, char *OpenMode);
    int ReadMwAutoLine(char *Dest, int MaxLen);
    int WriteMwAutoLine();
    int CloseMwAutoFile();

//    STR_SD_CARD StrSdCard;   // Struktur zum Speichern der Daten  
    
    FILE    *m_Fp;
    bool    m_fFileIsOpen;
    FILE    *m_FpHeader;
    bool    m_fHeaderIsOpen;
	
    FILE    *m_FpAutoFile;
    bool    m_fAutoFileIsOpen;
    
    FILE    *m_FpMwAutoFile;
    bool    m_fMwAutoFileIsOpen;

    char cSdValue[128];
    char cSdLine[512];
    char MessFileName[128];
    
};


#endif /* SDHCARD_H_ */




