/*-------------------------------------------------------------------------------
Programm Name:  RpaSerial.cpp
Version:        1.0
Sprache:        C++
Compiler:       mbed
Autor:          PS
Copyright:      PS
                 

Funktion:       Serial Funktions fuer Comm
04.08.2016:  Projekt: 
-------------------------------------------------------------------------------*/
#include "Headers.h"


RawSerial RpaDev(USBTX, USBRX);
int RawChar;
unsigned char Rc;
static int m_nLedCount;

/*-------------------------------------------------------------------------------
Folgendes ist zu beachten:
Die meisten Telegramme, die von EcmWin kommen, sind kurz, sie passen in einen 
typischen Empfangspuffer mit 2048 Byte. 
Werden jedoch Konfigurationsdaten oder Sequenzdateien uebertragen, dann koennen die 
Telegramme auch laenger sein. Hier muss vorgesorgt werden, sonst kommt es zu einem Chrash. 
Von EcmWin aus muessen die Daten in Bloecken geschickt werden, jeder Block muss eine 
STX und ein ETX haben. Die Firmware wiederum muss wissen, ob es sich um ein laengeres 
Telegramm handelt. Dies kann durch mitsenden eine zweiten Zeichens geschehen, 
trotzdem muss sich die Firmware merken, ob es sich um ein Starttelegramm oder um ein 
Folgetelegramm handelt. Z.B. wird bei der Uebertragun einer Ini-Datei mit dem ersten 
Telegramm die Datei geoeffnet, die Folgetegramme muessen einfach nur geschrieben und
mit dem letzten Telegramm muss die Ini-Datei geschlossen werden. 
-------------------------------------------------------------------------------*/
void SioCallback() 
{
    // Note: you need to actually read from the serial to clear the RX interrupt
    RawChar = RpaDev.getc();
    Rc = (unsigned char)RawChar & 0x00FF;
    HostIf.strRecBuf[HostIf.nRecEndPos] = Rc;
    if(Rc == ETX)    // Telegramm ist vollständig
    {
        HostIf.nInTel++;    // 
        HostIf.nEtxPos = HostIf.nRecEndPos;  // merken, falls waehrend der Verarbeitung ein weiterer IRQ kommt
		HostIf.nEtxPos &= 0x7FF; // steht jetzt auf der Pos. hinter dem letzten Zeichen
    }
	HostIf.nRecEndPos++; 
	HostIf.nRecEndPos &= 0x7FF; // steht jetzt auf der Pos. hinter dem letzten Zeichen
	
}
/*-------------------------------------------------------------------------------
InitInterface: Ist eine zentrale Methode. Fuer RS232 wird die serielle Schnittstelle 
initialisiert, fuer das Ethernet Interface wird Ethernet und Thread initialisiert
-------------------------------------------------------------------------------*/
int InitInterface()
{
    InitRawSio();   // ganz nach vorne, damit die Debug Ausgabe auch funktioniert
	return(true);
}
/*-------------------------------------------------------------------------------
-------------------------------------------------------------------------------*/
int InitRawSio() 
{
    RpaDev.baud(115200);  
    HostIf.nRecStartPos = 0; // Zeigt auf den Telegrammanfang 
    HostIf.nRecEndPos = 0;  // zu Beginn ist der Anfang gleich dem Ende
	HostIf.nEtxPos = 0; 
 	HostIf.fIsConnected = false;
    HostIf.nInTel = 0;
    HostIf.fSendMessage = false;
    HostIf.fSendError = false;
    RpaDev.attach(&SioCallback);
    return(true);
}
/*-------------------------------------------------------------------------------
-------------------------------------------------------------------------------*/
int TransferSioTel() 
{
    int i, j;
    
    for(i=HostIf.nRecStartPos, j=0;i != HostIf.nEtxPos;i++, j++)
	{
		i &= 0x7FF;
        HostIf.strTelAwBuf[j] = HostIf.strRecBuf[i];
	}
		
    HostIf.strTelAwBuf[j] = ETX;  
    HostIf.strTelAwBuf[j+1] = 0x00;  
	HostIf.nAwTelLen = j+1;
	i &= 0x7FF;
	HostIf.nRecStartPos = i;
	
	if(HostIf.nInTel > 0)
    	HostIf.nInTel--;
    return(true);
}

/*-------------------------------------------------------------------------------
-------------------------------------------------------------------------------*/
int ChangeLedColor() 
{
    LedGreen = false;
    LedBlue = false;
    LedRed = false;         // PTB22
    if(m_nLedCount == 0)
    {
        LedGreen = true;
        m_nLedCount++;
    }
    else if(m_nLedCount == 1)
    {
        LedBlue = true;
        m_nLedCount++;
    }
    else // if(LedCount == 2)
    {
        LedRed = true;
        m_nLedCount = 0;
    }
    return(true);    
    
}