/*-------------------------------------------------------------------------------
Programm Name: Struct.H
Version:       1.0
Sprache:       C
Compiler:      CrossStudio Ver. 2.0
Autor:         PS
Copyright:     PS
         

Funktion:      Strukturen fuer EcmCom

28.10.2012: 

-------------------------------------------------------------------------------*/
#define UINT8 unsigned char 
#define uint8_t UINT8
#define UINT16 unsigned int
#define uint16_t UINT16
#define uint UINT16
#define BYTE unsigned char
#define UINT32 unsigned long
#define uint32_t unsigned long
#define INT16 int

#define FALSE false
#define TRUE true

#define LOW     0
#define HIGH    1

#define ANZ_POT     2
#define ANZ_POLY    101

#define GEN_TYP_QST         1
#define GEN_TYP_FKT         0


/*===========================================================================
Die nachfolgende Struktur dient zur Speicherung der Startup Konfiguration
===========================================================================*/
struct StartUp
{
    int     HwConfig;   // KOnfiguration der Hardware
    int     StpConfig;  // ohne oder mit seriell to parallel

    int     PotAnz;     //  0 = 1 Pot. 1 = 2 Pot.
    int     AoInvert[ANZ_POT];
    float   Offset[ANZ_POT];
    int     PotTyp[ANZ_POT];     // 0=Alter, 1=PGU
    bool    fPotActive[ANZ_POT];
    bool    fStartConnection;
    bool    fNoiseMeasurement;

};
typedef struct StartUp START_UP;

/*===========================================================================
Die nachfolgende Struktur dient zur Verwaltung der Watchdogfunktion
===========================================================================*/
struct strWatchDog
{
    int     fEnabled;      // 0=kein Watchdog, 1=Watchdog aktiv
    int     nTimeOut;      // Timeout-Zeit für Watchdog
    char    cSign[8];      // Watchdog Zeichen was vom Host gesendet wird
    int     nCounter;
    int     nMsTimeOut;
    int     fLogFile;
    int     fHandShake;
};
typedef struct strWatchDog WATCH_DOG;

/*===========================================================================
Die nachfolgende Struktur dient zur Speicherung der Messkanaele
===========================================================================*/
struct MChn1
{
    float VarGalvFaktor;    // Variabler Faktor für die Ansteuerung Galvanostat

};
typedef struct MChn1 M_KANAL;

/*===========================================================================
 Die nachfolgende Struktur ist für die Meßparameter
===========================================================================*/
struct StrMPara
{
    int     RpDauer[ANZ_POT];           // Dauer der Ruhepotentialmessung
    int     RpDauerVor[ANZ_POT];        // Dauer der Ruhepotentialmessung
    int     RpDauerNach[ANZ_POT];       // Dauer der Ruhepotentialmessung
    int     IBereichPos[ANZ_POT];       // Position im Array
    float   IKritPos[ANZ_POT];          // Positiver Endwert des Kritischen Stromdichtebereiches
    float   IKritNeg[ANZ_POT];          // Negativer Endwert des Kritischen Stromdichtebereiches
    int     UKritPos[ANZ_POT];          // Positiver Endwert des Potential bei Galvanostat
    int     UKritNeg[ANZ_POT];          // Negativer Endwert des Potential bei Galvanostat
    int     GrenzVerhalten[ANZ_POT];    // Verhalten bei Grenzwertüberschreitung
    float   ProbenGroesse[ANZ_POT];     // Größe der Probe
    float   dUdTRpEnde[ANZ_POT];        // dU/dt für Rp-Ende
    double  SMax[ANZ_POT];              // für Galvanostat
    int     PolarisationsStart[ANZ_POT];// Start der Polarisation absolut oder relativ
};
typedef struct StrMPara MESS_PARAMETER;

/*===========================================================================
Struktur Deklaration für die Quasistationäre Funktion
===========================================================================*/
struct strQst1 {
                int     StartPotential;
                int     EndPotential;
                float   StufenHoehe;
                float   StufenDauer;
                int     AufAb;
                int     StartWertRelativ;
                int     AnzZyklen;
                float   flW_StartPotential; // Variable zum arbeiten
                float   flW_EndPotential; // Variable zum arbeiten
                float   flW_StufenHoehe[2]; // Variable zum arbeiten
                long    nW_StufenDauer;
                int     nW_Richtung;
                int     nW_StepCounter;
               };
typedef struct strQst1 QST_DATEN;

/*===========================================================================
 Struktur Definition für die Frequenzwerte and den DDS
===========================================================================*/
struct strFrqValues
{
    BYTE OutH0, OutH1;
    BYTE OutL0, OutL1;
    BYTE Clock;
    int nFilterAuto;
    BYTE AdControlLow;      // 0x00=Sinus, 0x02 = Dreieck
    bool fImpedance;
    BYTE V1, V2, Mux;
    bool fSendEnable;
    uint16_t nAktAmplitude;
    uint16_t nLastAmplitude;
};
typedef struct strFrqValues FRQ_VALUES;

/*===========================================================================
 Struktur zum Speichern der Generatorwerte
===========================================================================*/
struct FktStr2
{
    int     AnzPoly;   // Anzahl der Polygone einer Fuktion
    long    nAnzZyklus; // Anzahl der Zyklen
    long    ZyklusStartPunkt; // Einstiegspunkt für den Zyklus
    int     PolyNummer[ANZ_POLY+1]; // Satznummer
    double   ZeitWert[ANZ_POLY+1];// Abs. Zeitwerte der Polygone
    float   SpngWert[ANZ_POLY+1];   // Programmierter Spannungsw. der Polygone
    double  ScanRate[ANZ_POLY+1];   // Scanrate in mV/s
    int     ScanRichtung[ANZ_POLY+1]; // Richtung auf/ab/Sprung/Haltepot.
    float   RealSpngWert[ANZ_POLY+1];   // Tatsächlicher Spannungsw. der Polygone

    double  Schritt[ANZ_POLY+2];
    unsigned long    Count[ANZ_POLY+2];
    int     GenActive;
    long     ZCount;         // Zähler für Zyklus während der Messung
    double  GenVal;
    int     SetVal;         // Der aktuell zu setztende Integer-Wert
    int     LastSetVal;     // Der zuletzt gesetzte Integer-Wert
    float   MaxUS, MinUS;
    float   MaxTime;
    int     StartWertRelativ;
    int     FolgeWerteRelativ;
    float   flZyklusOffset;
    int     nZlOffsetMode;
    float   flScanOffset;
    int     VpStatus;   // wird vorpolarisiert, dann muá das eingearbeitet werden
    UINT16  nAktZyklus;
};
typedef struct FktStr2 FKT_WERTE;

/*===========================================================================
Struktur Deklaration für die Scanner Variablen
===========================================================================*/
struct strScanVal
{
    unsigned long GenCount;
    int GenPos;
    int Skiped;
    int Vz;
    bool SetStop;
    bool fNewCycle;
    float MaxUValue;
    float MinUValue;
    int AoMinWert, AoMaxWert;
};
typedef struct strScanVal SCAN_VAL;
/*===========================================================================
Struktur Deklaration für die Puls Variablen. Übernimmt die Pulswerte aus dem
Datentelegramm und hält die Werte ohne das sie vom Programm verändert werden
===========================================================================*/
struct strPulsValue
{
    int nPulsCounter;
    int nPulsPauseCounter;
    float flPulsStartPot;
    float flUpperPulsValue;
    float flLowerPulsValue;
    long   nAnzPulsUp;
    long   nAnzPulsDown;
    float flPulsOffset;
};
typedef struct strPulsValue PULS_VALUE;

/*===========================================================================
Struktur Deklaration für Puls Variablen. Diese Strukturvariablen dienen zum 
Arbeiten, können verändert werden und müssen im Bedarfsfalls aus den Basisdaten
neu geladen werden
===========================================================================*/
struct strPulsWorkValue
{
    int     nPulsCounter;
    int     nPulsPauseCounter;
    float   flUpperPulsValue;
    float   flLowerPulsValue;
    float   flPulsStartPot;
    long    nAnzPulsUp;
    long    nAnzPulsDown;
    float   flPulsOffset;
    bool    nPulsState;
};
typedef struct strPulsWorkValue PULS_WORK_VALUES;


/*===========================================================================
 Die nachfolgende Struktur ist für Variablen, die während der Messung
 von allen Messmodulen benötigt werden. Eine solche Struktur sollte für
 jeden zu messenden Potentiostaten separat angelegt werden. So läßt sich
 das Messen besser für Parallel-Messungen erweitern.
===========================================================================*/
struct StrMVariables
{
    int     BetriebsArt;        // Potentiostat=0, Galvanostat=1
    int     Circuit;            // OLP=0, I-Zelle = 1, Messung Ende = 2
    float   flAktIRange;        // Aktueller Max-Strom in mA
    float   RangeFaktor;
    float   IAktInVolt;
    int     GenDateiTyp;            // normal oder QST
    int     m_nReversePotential;
    int     m_nLastPotential;
    int     nMessArt;
    int     nReversed;

};
typedef struct StrMVariables MESS_VARIABLES;

/*===========================================================================
 Die nachfolgende Struktur ist für Variablen, die der I-Bereichsprüfung und
 Umschaltung dienen.
===========================================================================
struct StrIRange
{
    int     RangeAnz[ANZ_POT];
    int     AktRange[ANZ_POT];
    int     nIRangeMax[ANZ_POT];
    int     nIRangeMin[ANZ_POT];
    UINT32  lIMax[ANZ_POT];
    UINT32  lIMin[ANZ_POT];
    UINT32  lIMaxCompare[ANZ_POT];
    UINT32  lIMinCompare[ANZ_POT];
   
    int     TempRange;
    int     AutoRange[ANZ_POT];   // 0=aktiv, 1=nicht aktiv
    int     IDownCount[ANZ_POT];
    bool    m_fIRangeSwitchedUp[ANZ_POT];
    BYTE    RangeValue[ANZ_POT];
    int     Iz1, Iz2;
    float   I1, I2;
    float   IInVolt[ANZ_POT];
    bool    m_fCheckRange;
    bool    m_fAussenStromLos;
};
typedef struct StrIRange I_RANGE;
*/
/*===========================================================================
 Struktur Definition der Werte für die Änderung der Senderate während der Messung
===========================================================================*/
struct NewScanRate
{
    int nNewSendeRate;
    bool fFallBack; // nach einer bestimmten Anzahl zurücksetzen
    int nFallBackTime; // zurück zur alten Einstellung nach n Sekunden
    int nNewAutoRange;
    int nNewRange;  // neuer Bereich, wenn nicht -1 dann setzen
    int nOldSendAnzWerte;
    int nOldAutoRange;
    int nOldIntervall;
    int nExtSigOnOff;
    int n2ndExtSigOnOff;
};
typedef struct NewScanRate NEW_SCAN_RATE;


/*===========================================================================
 Struktur Definition von MessVariables
===========================================================================*/
struct MessVariables
{

    int     MwChn[16];
    int     SwitchChn[4];
    bool    m_fChnValid[16];    // Sagt, welcher Kanal übertragen wird, es werden 16 übertragen
    int     ZInfo[2];           // liefert dem Hauptrechner die Info, wo der Messablauf ist

    int     nAnzahlSchritte;    // Anzahl der Schritte pro Sekunde
    float   FrkValue[ANZ_POT];

    int     SendAnzWerte;   // Anzahl Werte, die pro Sekunden gesendet werden
    int     SendAnzSave;   // Zwischenspeicher fuer das Sendintervall
//    int     m_nStoreMwIntervall;    // Zeitabstand, in dem die Messwerte gespeichert werden
    int     m_nAnzChnSend;  // Zählt die Kanäle die gesendet werden
    int     m_nSendValues;  // das Senden von Single-Messdaten wird mit 1, Cont.Messdaten mit 2 freigegeben
    int     nMessZustand[ANZ_POT];
    int     nOldZustand[ANZ_POT];

//------------------------------------------------------------------------------

    long double  dbAdSum[ANZ_POT*4];
    double  dbAdResult[ANZ_POT*4];
    int     nChnAverage[ANZ_POT*4];
    
    long     nMwMittelCount; // wird nach jedem erfolgreichen Lesen des A/D Wandlers incrementiert
    int     nMittelTimer;   // zählt die Zeit, über die bisher gemittelt wurde
    int     nMittelAfter;   // ist die Zeit in ms, nach der gemäß der Anzahl der Werte eine Mittelung durchgeführt wird
    int     nAktMittelAfter; // ist der aktuelle Wert nach dem gemittelt wird
    int     nSendTimer;   // zählt die Zeit zwischen dem senden der Werte
    int     nDaTimer;   // zählt die Zeit zwischen der DA Wandlung
    int     nSendAfter;     // ist die Zeit in ms, nach der die Daten gesendet werden
    int     nDestCount;     // zählt die Werte im Zielpuffer der versendet wird
    bool    m_fStartTel;    // sagt, daß ein STX mit MW gesendet werden muss
    int     m_nAnzValue;
    int     nTelLen;
    bool    m_fSendStatus;
    bool    m_fPotGal;
    bool    m_fDoFinishMeasurement;
    bool    m_fFinishMeasurement;
    bool    m_fMeasurementFinished;  
    bool    m_fDisableStopTel;
    
//    int     nMwMittelVal;   // ist der Endwert, nachdem gesendet wird
    int     nSecCounter[2];
    bool    m_fScan;   // Flag zum aktivieren des Scanners
    bool    m_fScanPuls;
    bool    m_fPulsMessung;
    bool    m_fQstMessung;
    bool    m_fCellSwitchOff;
    bool    m_fChangeMittelValue;
    bool    fAdReInit;
    int     m_nSendAnz;
    int     nSwapNr;     // Nummer des Puffers in den die aktuellen Messdaten geschrieben werden

    int     Frk1, Frk2;
    float   Fr1, Fr2;
    int     m_nSendStart;
    int     m_nSendEnd;     // beginnt wieder von vorne
    int     nMwPerBlock;
    int     fTelStart;
    int     nBlockCount;
    int     nIpsDebug;
    uint8_t CsSpiMask;
// Ports für den I/O Zugriff
    uint16_t nRefPort;
    uint8_t nCurrentPort;
    uint8_t nRingPort;
    uint8_t nExtPort;
    uint8_t nGenPort;
    uint8_t nNoisePort;

    uint8_t nUGain;
    uint8_t nIGain;
    uint8_t CsOff;
    uint8_t IrKompPort;
    int     m_fMessDlgOpened;
    uint8_t AdConvTime;
    bool    fChangeCt; 
    int     nKurveForm;
    
    int     nMwMittelVal;
    int     m_nStoreMwIntervall;   


    int     nMessArt;
    int     nMessTimer;
    bool    fSequenzMessung;
    uint8_t fEnableAuto;  // wenn true, dann wir Enable Autorange gesetzt 
    int     nAnzPot;
    
};
typedef struct MessVariables MESS_VARS;

/*===========================================================================
 Struktur Speichern der der A/D Daten
===========================================================================*/
struct AnalogDigital
{
    double      AdResult[8][16]; // wird auch fuer den digitalen Filter verwendet
    UINT32      AdRingBuf[8][1024];
    long        AdTempU, AdTempU1, AdTempI, AdDiff;
    double      FKoeff[11];
    uint8_t     nStartFk, nEndeFk;
    double      dbUFkResult, dbIFkResult;
    double      dbUNoiseGainFaktor, dbINoiseGainFaktor;
};
typedef struct AnalogDigital AD_VAL;


/*===========================================================================
 Struktur für das IR-Handling
===========================================================================*/
struct IrCompensation
{
    double  dbRArray[8];
    uint8_t nRIndex;
    bool    fMitIrValue;
    bool    fMosFetState;
    bool    fMosFetOpen;
    bool    fWaitForIrVoltage;
    bool    fSendInfo;
    bool    fIrInProcess;
    bool    fCalculate;
    
    double  dbIrValue[16], dbRValue, dbOldRValue;
    double  dbIrAddVoltage, dbKorrVoltage;
    
    double  dbUDiffValue, dbLastIValue, dbUScale;
    uint8_t nIChn, nUChn;
    double  dbAOut[2];
    double  dbDiv, dbUDisplay;     // zum Berechnen der Spannung
    uint16_t nMosFetCounter;
    uint8_t n100msCounter;  // wird alle 100ms incrementiert, Zeitfenster für die IR-Unterbrechung
    uint8_t nOffCount;
    uint8_t nOffSollCount;
    uint16_t nSollCounter;
    uint8_t nStartupCounter;
    uint8_t nDistanceCounter;
    uint8_t nSkipCounter;
   
};
typedef struct IrCompensation IR_COMP;


