/*-------------------------------------------------------------------------------
Programm Name: OpenDevId.h
Version:       1.0
Sprache:       C
Compiler:      MBED
Autor:         PS
Copyright:     PS
               

Funktion:      Liest die ID-Datei und überträft diese an EcmWin. Damit kann 
                EcmWin den Gerätetyp eintragen. Wenn nicht vorhanden, dann kommt
                ein NAK
-------------------------------------------------------------------------------
*/

#define ANZ_DEV_KEY     28


/*===========================================================================
Die nachfolgende Struktur dient zur Speicherung der Dev-Daten, die von EcmWin 
gelesen werden
===========================================================================*/
struct strDevIni
{
    int     nDevIndex;          // Geräteindex
    int     nPotRev;            // Hardware Rev
    double  dbPotVar;           // Variabler Faktor für das Anzeigepotential
    double  dbScanVar;          // Variabler Faktor für das Scannerpotential
    int     nPotChn;            // Messkanal Potential
    int     nCurrChn;           // Messkanal Strom
    int     nAmpChn;            // Messkanal Verstärker
    int     nAmpActive;         // Stromverstärker aktiv
    int     nSwIz;              // Schalter OCP/Izelle
    int     nSwPotGal;          // Schalter Pot/Gal
    int     nPotInverted;       // Potentialanzeige invertiert
    int     nOPotInv;           // Scanner Potential invertiert
    int     nOGalInv;           // Scanner Galvanostat invertiert
    double  dbGalVar;           // Variabler Faktor für Galvanostat
    int     nUnChn;             // Messkanal UNoise
    int     nInChn;             // Messkanal INoise
    int     nNoiseActive;       // Noisemessung aktiv
    double  dbLpcCal0;          // 1. Faktor für LpcKalibrierung
    double  dbLpcCal1;          // 2. Faktor für LpcKalibrierung
    double  dbLpcCal2;          // 3. Faktor für LpcKalibrierung
    double  dbLpcCal3;          // 4. Faktor für LpcKalibrierung
    double  dbLpcCal4;          // 5. Faktor für LpcKalibrierung
    double  dbLpcCal5;          // 6. Faktor für LpcKalibrierung
    double  dbLpcCal6;          // 7. Faktor für LpcKalibrierung
    double  dbLpcCal7;          // 8. Faktor für LpcKalibrierung
    int     nInstBoard;        // Installierte Messkarte
    int     nSRateIndex;       // Index Samplerate
    int     nAvValue;           // Average Value    
    
};
typedef struct strDevIni DEV_INI;


extern DEV_INI DevIni;


// Funktionen aus OpenDevId.cpp
//------------------------------------
extern int OpenDevIni();
extern void InitDevIni();
extern int WriteDevFile();

extern int DecDevIndex(char *Line);
extern int DecPotRev(char *Line);
extern int DecPotVar(char *Line);
extern int DecScanVar(char *Line);
extern int DecPotChn(char *Line);
extern int DecCurrChn(char *Line);
extern int DecAmpChn(char *Line);
extern int DecAmpActive(char *Line);
extern int DecSwIz(char *Line);
extern int DecSwPg(char *Line);
extern int DecPotInverted(char *Line);
extern int DecOPotInv(char *Line);
extern int DecOGalInv(char *Line);
extern int DecGalVarVal(char *Line);
extern int DecUnChn(char *Line);
extern int DecInChn(char *Line);
extern int DecInActive(char *Line);
extern int DecLpcCalC0(char *Line);
extern int DecLpcCalC1(char *Line);
extern int DecLpcCalC2(char *Line);
extern int DecLpcCalC3(char *Line);
extern int DecLpcCalC4(char *Line);
extern int DecLpcCalC5(char *Line);
extern int DecLpcCalC6(char *Line);
extern int DecLpcCalC7(char *Line);
extern int DecInstBoard(char *Line);
extern int DecSRateId(char *Line);
extern int DecAvValue(char *Line);
