/*-------------------------------------------------------------------------------
Programm Name:  Dio.h
Version:        1.0
Sprache:        C
Compiler:       mbed
Autor:          PS
Copyright:      PS

Funktion:       I/O Signale für Messbereichszugriffe, U-Ruhe/IZelle, Pot/Gal usw.
-------------------------------------------------------------------------------*/

// D-I/O's
//-----------------------------------------------------------------------------
extern DigitalOut led1; // (LED1);
extern DigitalOut led2; // (LED2);
extern DigitalOut led3; //(LED3);
extern DigitalOut led4; //(LED4);


#ifdef CURRENT_5A_PIO
extern DigitalOut CsCurrent;     // Enable
extern DigitalOut CsTemp1;       // A0 
extern DigitalOut CsTemp2;       // A1
extern DigitalOut CsIrComp;       // A2 
#else

extern DigitalOut EnableOffset; //Offset freigeben

#endif


// Macros
/*-----------------------------------------------------------------------------
#define Spi0IsMisoUp()  (LPC_GPIO0->FIOPIN & 0x00020000)
#define Spi0IsMisoDown()  (LPC_GPIO0->FIOPIN & ~0x00020000)

#ifdef EXT_AB

    #define SkIzUp()  (LPC_GPIO2->FIOSET |= 0x00000001)     // CsIrKomp
    #define SkIzDown()  (LPC_GPIO2->FIOCLR |= 0x00000001)   // 

    #define PotGalUp()  (LPC_GPIO2->FIOSET |= 0x00000002)   // CsCurrent
    #define PotGalDown()  (LPC_GPIO2->FIOCLR |= 0x00000002)
#else
    #ifdef PGU_MOD_OLD

    #define SkIzUp()  (LPC_GPIO0->FIOSET |= 0x00040000)
    #define SkIzDown()  (LPC_GPIO0->FIOCLR |= 0x00040000)

    #define PotGalUp()  (LPC_GPIO0->FIOSET |= 0x00008000)
    #define PotGalDown()  (LPC_GPIO0->FIOCLR |= 0x00008000)
    
    #else

    #define SkIzUp()  (LPC_GPIO2->FIOSET |= 0x00000001) // CsIrKomp
    #define SkIzDown()  (LPC_GPIO2->FIOCLR |= 0x00000001)

    #define PotGalUp()  (LPC_GPIO2->FIOSET |= 0x00000002)   // CsCurrent
    #define PotGalDown()  (LPC_GPIO2->FIOCLR |= 0x00000002)

    #endif
#endif

#ifdef IMP_INTERFACE

#define SkIzUp()  (LPC_GPIO2->FIOSET |= 0x00000001)     // CsIrKomp
#define SkIzDown()  (LPC_GPIO2->FIOCLR |= 0x00000001)   // 

#define PotGalUp()  (LPC_GPIO2->FIOSET |= 0x00000002)   // CsCurrent
#define PotGalDown()  (LPC_GPIO2->FIOCLR |= 0x00000002)

#define IRangeEnable()  (LPC_GPIO2->FIOSET |= 0x00000004)   // CsSinGen
#define IRangeDisable()  (LPC_GPIO2->FIOCLR |= 0x00000004)   // CsSinGen

#endif

// Für die wenigen externen Geräte die noch über eine Box angesteuert werden
#define K0_Up()       (LPC_GPIO2->FIOSET |= 0x00000001)
#define K0_Down()     (LPC_GPIO2->FIOCLR |= 0x00000001)
#define K1_Up()       (LPC_GPIO2->FIOSET |= 0x00000002)  
#define K1_Down()     (LPC_GPIO2->FIOCLR |= 0x00000002)
#define K2_Up()       (LPC_GPIO2->FIOSET |= 0x00000004)  
#define K2_Down()     (LPC_GPIO2->FIOCLR |= 0x00000004)
#define K3_Up()       (LPC_GPIO2->FIOSET |= 0x00000008)  
#define K3_Down()     (LPC_GPIO2->FIOCLR |= 0x00000008)

#define K4_Up()       (LPC_GPIO2->FIOSET |= 0x00000020)  
#define K4_Down()     (LPC_GPIO2->FIOCLR |= 0x00000020)
#define K5_Up()       (LPC_GPIO2->FIOSET |= 0x00000010)  
#define K5_Down()     (LPC_GPIO2->FIOCLR |= 0x00000010)
#define K6_Up()       (LPC_GPIO1->FIOSET |= 0x40000000)  
#define K6_Down()     (LPC_GPIO1->FIOCLR |= 0x40000000)
#define K7_Up()       (LPC_GPIO1->FIOSET |= 0x80000000)  
#define K7_Down()     (LPC_GPIO1->FIOCLR |= 0x80000000)

*/

// Funktionen aus Dio.cpp
//------------------------------------
extern int SetBaVariablen(int Nr, bool Level);
extern int Setk(int Nr, bool Level);
extern int SetkPio(int Nr, bool Level);
extern int SetkPguMod(int Nr, bool Level);
extern int SetkPguStack(int Nr, bool Level);
extern void SetRefFilter(unsigned char Rng);
extern void SetUGainMux(unsigned char Range);
extern void SetIGainMux(unsigned char Range);
extern void SetUOffset(unsigned char Range);
extern void SetFrqGain(BYTE V1, BYTE V2, BYTE Mux);
extern void SinOnOff(int State);
extern int InitDio(void);
extern void SetRefSpiRange();
extern void SetCurSpiRange();
// extern void WriteToSpiPort(unsigned char Port);
extern void SetExtBnc(int State, int Nr);
extern int ChangeMittelValue();
extern int SwitchRangesOnStart();
extern void SetCurBiRange();
extern int SetIZelleBasis(int Nr, bool Level);
extern void WriteToStackPort(unsigned int Port);
extern void SetRefStackRange();


