/*-------------------------------------------------------------------------------
Programm Name: AdInit.cpp
Version:       1.0
Sprache:       C++
Compiler:      mbed
Autor:         PS
Copyright:     PS
         

Funktion:      Init-Funktion für den A/D Wandlerzugriff

30.06.2017: 

-------------------------------------------------------------------------------*/
#include "Headers.h"

bool fChnValid[8];


/*-------------------------------------------------------------------------------
Analog-Digital Konverter initialisieren
-------------------------------------------------------------------------------*/
void InitAdValues()
{
    int i,j;
    
    AdVal = new (AD_VAL);    
    for(i=0;i<ANZ_POT*4;i++)
    {
        g_fARead[i] = false;
        MVars.dbAdSum[i] = 0.;
        for(j=0;j<16;j++)
        {
            AdVal->AdResult[i][j] = 0.0;
        }
    }
    for(i=0;i<ANZ_POT*4;i++)
    {
        for(j=0;j<64;j++)
            AdVal->AdRingBuf[i][j] = 0L;
    }
    g_nAdSetPos = 0;
    g_nAdGetPos = 0;
    g_nAdCount = 0;

    g_nAdResultCount = 0;
   
    AdVal->FKoeff[0] = -0.7128E-3;
    AdVal->FKoeff[1] = 0.01879;
    AdVal->FKoeff[2] = 0.06321;
    AdVal->FKoeff[3] = 0.125;
    AdVal->FKoeff[4] = 0.1806;
    AdVal->FKoeff[5] = 0.20305;
    AdVal->FKoeff[6] = 0.1806;
    AdVal->FKoeff[7] = 0.125;
    AdVal->FKoeff[8] = 0.06321;
    AdVal->FKoeff[9] = 0.01879;
    AdVal->FKoeff[10] = -0.7128E-3;
   
    AdVal->nStartFk = 11;
    AdVal->nEndeFk = 5;
   
    AdVal->dbUNoiseGainFaktor = 0.1;
    AdVal->dbINoiseGainFaktor = 1.0;
   
    MVars.AdConvTime = 0x7F; // Startwert, längste Wandlungszeit ohne  Chop Mode 0x80 ist Chopper
}


/*-------------------------------------------------------------------------------
Interrupt für den A/D Wandler einrichten. InterruptIn AdcRdy(PTB10) liegt hier 
auf PTB10, muss je nach Hardware angepasst werden 
-------------------------------------------------------------------------------*/
int InitSpiAd(void)
{
    Adc0Cs = true;
    Adc1Cs = true;
    
    AdcRdy0.mode(PullUp);
    AdcRdy1.mode(PullUp);

    Ad0CsUp();
    AdSckUp();
    printf("Nach Set Irq's\n");
    return(true);
}
/*-------------------------------------------------------------------------------
Interrupt für den A/D Wandler einrichten. InterruptIn AdcRdy(PTB10) liegt hier 
auf PTB10, muss je nach Hardware angepasst werden 
-------------------------------------------------------------------------------*/
int ConnectIrq(void)
{
    AdcRdy0.fall(&Rdy0Fall);
    AdcRdy1.fall(&Rdy1Fall);
    return(true);
}
    
/*-------------------------------------------------------------------------------
-------------------------------------------------------------------------------*/
void AdReset()
{
// macht einen kompletten Reset auf den Wandler
    DoAdReset();
    printf("Nach AdReset CommonWrite Hex 00\n");

    wait(2.0);
   
}
/*-------------------------------------------------------------------------------
Macht einen Reset des A/D Wandlers
-------------------------------------------------------------------------------*/
void DoAdReset()
{
  int i;
  
  AdSckUp();
  AdMosiDown();
  Ad0CsDown();
  Ad1CsDown();
  short_delay(2);
  
  for(i=0;i<8;i++)
  {
      AdSckDown();
      short_delay(2);  // min. 50ns SCK low
       AdSckUp();
      short_delay(2);  // min. 50ns SCK high
  }
  AdMosiUp();
  for(i=0;i<32;i++)
  {
      AdSckDown();
      short_delay(2);  // min. 50ns SCK low
       AdSckUp();
      short_delay(2);  // min. 50ns SCK high
  }
  Ad0CsUp();
  Ad1CsUp();
}

/*-------------------------------------------------------------------------------
// Rdy ist der Interrupt von AD7734 
#define Ad0IsRdyUp()    (GPIOB_PDIR & 0x000000400)
-------------------------------------------------------------------------------*/
int AdIsRdyUp(int Chn)
{
    if(Chn == 0)
        return(Ad0IsRdyUp());
    else
        return(Ad1IsRdyUp());
}

/*-------------------------------------------------------------------------------
-------------------------------------------------------------------------------*/
void Ad7739Init(int EcmWinCall)
{
  // Power on Reset
    uint8_t i, j;
    
    for(i=0;i<8;i++)
        fChnValid[i] = false;
    



// Conversiontime zuerst setzen, da dies auf die Kalibrierzeiten wirkt
    SetAdConversionTime();

// die ersten vier Kanäle sind aktiv
    for(i=0;i<3;i++)
    {
        fChnValid[i] = true;
        MVars.m_fChnValid[i] = true;
    }
    
#ifdef SIO_DEBUG
    STemp[0] = 0x00;
    for(i=0;i<8;i++)
    {
        sprintf(SDebug, "Chn%d: %d", i, fChnValid[i]);
        strcat(STemp, SDebug);
    }
    printf("%s \r\n",STemp);
#endif            
    
    ReadAdRevisionRegister(0);
    ReadAdRevisionRegister(1);

// Self Calibration
    for(i=0;i<2;i++)
    {
        Ad7739OutWrite(AD7739_WRITE_OP(AD7739_CHANNEL(AD7739_ADDR_MODE, 0)),i);  //Mode Register 0x38
        Ad7739OutWrite(0x82,i);  // ADC Zero-Scale  schreibt nur in das erste, das genuegt
        nMyTimer = 0;
        while( (AdIsRdyUp(i) && (nMyTimer < 2000))); // && Ad1IsRdyUp());
        if(nMyTimer >=2000)
            printf("Self Calibration finish on Timer \r\n");
        
    }
/*
#ifdef SIO_DEBUG
    printf("Nach SelfCalibration %d\r\n", nMyTimer);
#endif            
        Status0 = ReadAdStatusRegister(0);
        Status1 = ReadAdStatusRegister(1);
#ifdef TFT_DEBUG    
        printf("St0: %d   St1: %d \n", Status0, Status1);
#endif    
*/

// Fullscale Calibration
    for(i = 0; i < 2; i++)  //  muss nur für die erste Adresse geschrieben werden gilt für acht Kanäle 
    {
        Ad7739OutWrite(AD7739_WRITE_OP(AD7739_CHANNEL(AD7739_ADDR_MODE, 0)),i);
        Ad7739OutWrite(0xA2,i);  // ADC Full-Scale und 24 Bit
        nMyTimer = 0;
        while( (AdIsRdyUp(i) && (nMyTimer < 2000))); // && Ad1IsRdyUp());
        if(nMyTimer >=2000)
            printf("FullScale Calibration finish on Timer \r\n");
    }
/*    
#ifdef SIO_DEBUG
    printf("Nach FullScaleCalibration %d\r\n", nMyTimer);
#endif            
        Status0 = ReadAdStatusRegister(0);
        Status1 = ReadAdStatusRegister(1);
#ifdef TFT_DEBUG    
        printf("St0: %d   St1: %d \n", Status0, Status1);
#endif    
*/    

//
// Channel Setup Register 0x28 bis 0x2F

// Schreiben des Channel Setup Registers 0x28 bis 0x2F
// Bit 2 setzt den +-2,5V Bereich, Bit 3 enabled den Kanal, Bit 5 und Bit 6 setzen den Differential Mode 
// beide auf 0 heißt single ended



    for(i=0;i<4;i++)   // Wandler 0
    {
        Ad7739OutWrite(AD7739_WRITE_OP(AD7739_CHANNEL(AD7739_ADDR_C_SET, i)),0);  // Geht an Wandler Diff Mode AI0 
        Ad7739OutWrite(0x08,0);  // 08 = +- 10V, 0A = +- 5V
        nMyTimer = 0;
        while( (AdIsRdyUp(0) && (nMyTimer < 2000))); // && Ad1IsRdyUp());
        if(nMyTimer >=2000)
            printf("ADC0 active and Range on Timer \r\n");
        short_delay(10);
    }        
    for(i=0;i<4;i++)   // Wandler 1
    {
        Ad7739OutWrite(AD7739_WRITE_OP(AD7739_CHANNEL(AD7739_ADDR_C_SET, i)),1);  // Geht an Wandler Diff Mode AI0 
        Ad7739OutWrite(0x00,1);  // 08 = +- 10V, 0A = +- 5V, zweiter Wandler wird nicht gebraucht 
        nMyTimer = 0;
        while( (AdIsRdyUp(1) && (nMyTimer < 2000))); // && Ad1IsRdyUp());
        short_delay(10);
        if(nMyTimer >=2000)
            printf("ADC1 active and Range on Timer \r\n");
    }        

    printf("Nach Setup AD 1 %d\r\n", nMyTimer);
        

    
// IO Register        
    for(j=0;j<2;j++)
    {
        Ad7739OutWrite(AD7739_WRITE_OP(AD7739_ADDR_IO),j);
        Ad7739OutWrite(0x30,j);    // 0x08 sagt, daß der Ready Pin low geht, wenn alle Kanäle konvertiert sind
    }
    printf("Nach IO Register \r\n");

    AdSckUp();
    AdMosiDown();
    
    ReadAdIoPortRegister(0);
    ReadAdIoPortRegister(1);
    ReadAdRevisionRegister(0);
    ReadAdRevisionRegister(1);
    
    ReadAdTestRegister(0);
    
    ReadAdChnZeroScaleRegister(0);
    ReadAdChnZeroScaleRegister(1);
    
    
/*    while(true)
    {
        AdReadChannels(0,0,0);  // Kanal, Wandler, ohne/mit Status
        AdReadChannels(0,1,0);  // Kanal, Wandler, ohne/mit Status
    }    
*/
}
/*-------------------------------------------------------------------------------
Setzt die Wandlungszeit für die A/D Wandler
-------------------------------------------------------------------------------*/
void SetAdConversionTime()
{
    int i;
    uint8_t AdConversionTime;


// Wandlungszeit FF bedeutet Chopper ist an und 7F ist dei max. Wandlungszeit
// Die minimale Wandlungszeit ist 0x02, d.h. mit Chopper ist es 0x82, ohne 0x02
//    AdConversionTime = MVars.AdConvTime;
    AdConversionTime = 0x7F;
    for(i = 0; i < 4; i++)
    {
      Ad7739CommonWrite(AD7739_WRITE_OP(AD7739_CHANNEL(AD7739_ADDR_C_CT, i)));  //0x30 conversion time
      Ad7739CommonWrite(AdConversionTime);
//      ReadAdConvTimeRegister();
    }
}
