/*-------------------------------------------------------------------------------
Programm Name: AdGlobals.cpp
Version:       1.0
Sprache:       C++
Compiler:      mbed
Autor:         PS
Copyright:     PS
         

Funktion:      Globale Variablen für den A/D Wandlerzugriff

30.06.2017: 

-------------------------------------------------------------------------------*/
#include "Headers.h"


// I/O's für den A/D Wandler
DigitalOut AdcSck(PTC10);
DigitalIn AdcMiso(PTC11);
DigitalOut AdcMosi(PTB11);

InterruptIn AdcRdy0(PTB10);
InterruptIn AdcRdy1(PTC9);

DigitalOut Adc0Cs(PTB3);
DigitalOut Adc1Cs(PTC8);

DigitalIn AdcReset(PTB2);


// Globale Variablen
//-------------------------------------
uint8_t g_TempDelay;
uint8_t g_AReadTemp;
uint8_t g_nAdResultCount;


bool g_fAdConversion; 
bool g_fRdy0, g_fRdy1;


AD_VAL *AdVal;

UINT8 g_fARead[8];
uint8_t g_nAdSetPos, g_nAdGetPos;
int g_nAdCount;
UINT32 m_AdTemp[8];


/*-------------------------------------------------------------------------------
Schreibt die Inits auf beide AD Wandler
-------------------------------------------------------------------------------*/
void Ad7739CommonWrite(uint8_t b)
{
  uint8_t mask = 0x80;
  AdSckUp();
  Ad0CsDown();
  Ad1CsDown();
  short_delay(2);
  do
  {
      AdSckDown();
      short_delay(2);  // min. 50ns SCK low
      (b & mask) ? (AdMosiUp()) : (AdMosiDown());
      short_delay(2);  // min. 30ns bevor die Flanke hochgeht
       AdSckUp();
      short_delay(2);  // min. 50ns SCK high
  }
  while(mask >>= 1);
//  AdMosiUp();
  Ad0CsUp();
  Ad1CsUp();
}
/*-------------------------------------------------------------------------------
-------------------------------------------------------------------------------*/
void Ad7739OutWrite(uint8_t b, int Wandler)
{
    uint8_t mask = 0x80;
    AdSckUp();
    if(Wandler == 0)
        Ad0CsDown();
    else
        Ad1CsDown();
    short_delay(2);  // min. 50ns SCK low
    do
    {
        AdSckDown();
        short_delay(2);  // min. 50ns SCK low
        (b & mask) ? (AdMosiUp()) : (AdMosiDown());
        short_delay(2);  // min. 30ns bevor die Flanke hochgeht
        AdSckUp();
        short_delay(2);  // min. 50ns SCK high
    }
    while(mask >>= 1);
    Ad0CsUp();
    Ad1CsUp();
    AdMosiDown();
}
/*-------------------------------------------------------------------------------
Startet einen einzelnen A/D Wandler. Wenn Mode = 0, dann single Mode, wenn Mode 
= 1, dann continous Mode. 
-------------------------------------------------------------------------------*/
void Ad7739Start(uint8_t Chn, uint8_t Wandler, uint8_t Mode)
{
    
    if(Mode == 0)   // Single Mode
    {
        Ad7739OutWrite(AD7739_WRITE_OP(AD7739_CHANNEL(AD7739_ADDR_MODE, Chn)), Wandler);
        Ad7739OutWrite(0x42, Wandler);   // 0x26 ist continous mode
    }
    else // continuous
    {
        Ad7739OutWrite(AD7739_WRITE_OP(AD7739_CHANNEL(AD7739_ADDR_MODE, Chn)), Wandler);
        Ad7739OutWrite(0x2E, Wandler);   // 0x26 ist continous mode0x08=Dump Mode, 0x04: Continous Read
        Ad7739OutWrite(0x48, Wandler);   // the first write of 48 start the continous read mode
//        g_nIRead = 0;
        AdMosiDown(); // muss unten sein, da sonst der Continous Mode gestoppt werden kann

    }
    __enable_irq();             // 2017-05-31

}
/*-------------------------------------------------------------------------------
-------------------------------------------------------------------------------*/
void Ad7739CommonStart(uint8_t Chn, uint8_t Mode)
{
    if(Mode == 0)   // Single Mode
    {
        Ad7739CommonWrite(AD7739_WRITE_OP(AD7739_CHANNEL(AD7739_ADDR_MODE,Chn)));
        Ad7739CommonWrite(0x42);   // 0x26 ist continous mode
    }
    else // continuous
    {
        Ad7739CommonWrite(AD7739_WRITE_OP(AD7739_CHANNEL(AD7739_ADDR_MODE, Chn)));
        Ad7739CommonWrite(0x2E);   // 0x26 ist continous mode
        Ad7739CommonWrite(0x48);   // 0x26 ist continous mode
    }
    
    g_fAdConversion = true;    // 2017-05-31
    __enable_irq();             // 2017-05-31

}

/*-------------------------------------------------------------------------------
-------------------------------------------------------------------------------*/
void Ad7739Stop(void)
{
    // single
    /* return; */

    // continous
    Ad7739CommonWrite(AD7739_WRITE_OP(AD7739_ADDR_MODE));
    Ad7739CommonWrite(0x02);
    
    g_fAdConversion = false;    // 2017-05-31
    __enable_irq();             // 2017-05-31
}
