/*
-------------------------------------------------------------------------------
Programm Name: DaMethoden.C
Version:       1.0
Sprache:       C
Compiler:      CrossStudio Ver. 2.0
Autor:         PS
Copyright:     PS
         

Funktion:      Init und Io fuer den D/A Wandler

28.10.2012: 

-------------------------------------------------------------------------------*/
/*-------------------------------------------------------------------------------
-------------------------------------------------------------------------------*/
#include "Headers.h"


// Private Definitionen
/** Max buffer length */


// Rev B und C


// Private Variablen

int nDCounter;
unsigned char Low, High;




/*-------------------------------------------------------------------------------
Initialisieren der Pins fuer den DA Wandler
-------------------------------------------------------------------------------*/
int InitDac(void)
{
    int i;
/*
Initialisieren der Pins fuer den D/A Zugriff:
    Mosi = 0;       // Mosi für den D/A Wandler
    CsDac = 1;      // CS für den D/A Wandler, 0 = Cs aktiv, (low active) 
    Sck = 0;       // SCK für den D/A Wandler

*/
    DacCs = 0;
    DacSck = 1;
    DacMosi = 0;

    for(i=0;i<3;i++)
    {
        DacSck = 0;
        DacSck = 1;    // D23 bis D21 auf 0
    }
    DacMosi = 1;   // D20 auf 1, load DAC A
    DacSck = 0;
    DacSck = 1;
    DacMosi = 0;
    
    for(i=4;i<24;i++)
    {
        DacSck= 0;
        DacSck = 1;    // D19 bis D0 auf  0
    }
    Low = 0x00;
    High = 0x00;
    return(true);
}
/*-------------------------------------------------------------------------------
Testen des D/A Wandlers
-------------------------------------------------------------------------------*/
int TestDac(void)
{
    Low++;
    SpiSendDa (0, 0);
    if(Low == 0xFF)
    {
        High++;
    }
    return(true);
}
/* ********************************************************************
macht das komplette Out fuer 24 Bit
 ***********************************************************************/
int SpiSendDa (uint8_t Channel, uint16_t Mode)
{
    uint32_t WData0, WData1,WData2;
    uint16_t n;
    uint32_t Mask;
    uint32_t tmp;
    
    DacSck = 0;
    DacCs = 0;
    
    // 2016-06  UFa: Aenderungen aufgrund HW-Revision
    short_delay(1);

    n = 0;
    WData0 = 0x10;
    WData1 = High;
    WData2 = Low;
    Mask = 0x0800000;
    tmp = 0;
    tmp = ((WData0 << 16) | (WData1 << 8) | (WData2));
    for(n=0;n<24;n++)
    {
        DaSckUp();
        short_delay(1);
        if(tmp & Mask)
          DaMosiUp();
        else
          DaMosiDown();
        short_delay(1);
        DaSckDown();
        short_delay(1);
        Mask >>= 1;
    }
    // 2016-06  UFa: Aenderungen aufgrund HW-Revision
    DacCs = 1;
    DacSck = 1;
    short_delay(1);
    
    return (0);
}

/*-------------------------------------------------------------------------------
Berechnen der Daten an den DA Wandler. Wird erst mal für die Anschlussbox berechnet, 
bei der jeweils 2 Kanäle auf einen Ausgang addiert werden 
-------------------------------------------------------------------------------*/
void CalcDa(double SourceVal, UINT8 Chn)
{
//    DigitalOut CsTest(PTC16);    // nur wegen dekativierung durch Ethernet. Ich hoffe, das wird wieder anders
    unsigned int OutValue;
    double Counts;
    double SrcVal;


    SrcVal = SourceVal;
    
    Counts = SrcVal * 13.107;
    
    OutValue = (uint16_t)(Counts);

    Low = OutValue;
    High = (OutValue >> 8);
    SpiSendDa(0,1);
}

/*-------------------------------------------------------------------------------
Senden der Daten an den DA Wandler
-------------------------------------------------------------------------------*/
void SendDataDa(void)
{
  SpiSendDa(0,3);
}








