#include "mbed.h"
#include "C12832.h"
InterruptIn joystickcenter(p14);
InterruptIn wire(p9);
DigitalOut led(LED1);
DigitalOut flash(LED4);
C12832 lcd(p5,p7,p6,p8,p11);
Timer debounce;
int i;
void flip()
{
    if (debounce.read_ms() > 800) {
    led = !led; // toggles the led when the joystick button is pressed.          
    debounce.reset ();
    i=1;    
    }
    }
    int main() {
        joystickcenter.rise(&flip); // attach the function address to the rising edge
        wire.mode(PullUp); // With this, no external pullup resistor needed
        wire.rise(&flip); // attach the function address to the rising edge
        debounce.start();
        while(1) { // wait around, interrupts will interrupt this!
            flash = !flash; // turns LED4 on if off, off if on
            wait(0.5); // the instruction to wait for half-second 
            if(i==1) {
                lcd.locate(0,0);
                lcd.printf("button press detected\n\r");           
                lcd.printf("%d\n\r", debounce.read_ms());        
            i=0;
            }
        }
    }