#include "HardwareControl.h"

HardwareControl::HardwareControl(){
        /*
        SOL1(p25);
        SOL2(p26);
        SOL3(p27);
        SOL4(p28);
        SOL5(p23);
        SOL6(p22);
        SOL7(p21);   
        
        */
        
}



void HardwareControl::playNote(int binaryNote, int length){
        
        
        // Solenoc note controls
        // =====================
        //   
        // C arpeggio : 1 - 193 - 241 - 254 
        // 
        // C:  NONE ASSERTEDS, AIR 
        //     Binary represent-------------ation:  00000001
        //     Integer representation: 1
        
        // D:  SOL1, AIR          
        //     Binary representation:  10000001
        //     Integer representation: 129
        
        // E:  SOL1, SOL2, AIR 
        //     Binary representation:  11000001
        //     Integer representation: 193
        
        // F:  SOL1, SOL2, AIR
        //     Binary representation:  11100001
        //     Integer representation: 225
        
        // Fs: SOL1, SOL3, SOL4, AIR
        //     Binary representation:  10110001
        //     Integer representation: 177
        
        // G:  SOL1, SOL2, SOL3, SOL4, AIR
        //     Binary representation:  11110001
        //     Integer representation: 241
        
        // Gs: SOL1, SOL3, SOL4, SOL5, AIR
        //     Binary representation:  10111001
        //     Integer representation: 185
        
        // A:  SOL1, SOL2, SOL3, SOL4, SOL5, AIR
        //     Binary representation:  11111001
        //     Integer representation: 249
        
        // As: SOL1, SOL3, SOL4, SOL5, SOL6, AIR
        //     Binary representation:  10111101
        //     Integer representation: 189
        
        // B:  SOL1 - SOL6, AIR
        //     Binary representation:  11111101
        //     Integer representation: 254
        
        // R:  ALL ASSERTED // REST
        //     Binary representation:  11111110
        //     Integer representation: 254
        
        
        DigitalOut SOL1(p25);
        DigitalOut SOL2(p26);
        DigitalOut SOL3(p27);
        DigitalOut SOL4(p28);
        DigitalOut SOL5(p23);
        DigitalOut SOL6(p22);
        DigitalOut SOL7(p21);
        DigitalOut AIR(p24); //Air

        SOL1 = binaryNote & 128;
        SOL2 = binaryNote & 64;
        SOL3 = binaryNote & 32;
        SOL4 = binaryNote & 16;
        SOL5 = binaryNote & 8;
        SOL6 = binaryNote & 4;
        SOL7 = binaryNote & 2;
        AIR = binaryNote & 1;
        
        wait_ms(length);
        
}