/*
In this part of the Lab 3, you will make a digital thermometer using the SEN-11931 breakout board as well as the 4-bank seven-segment LED display.

Study carefully chapter 7 regarding the digital temperature sensor provide in the lab kit, referring to the TMP102 datasheet and SEN-11931 
breakout board schematics (under Weeks 5 & 6 --> Lab 3 Extra Files).

Design the hardware connection of the SEN-11931, reusing the connection from part I of the this lab, 
for the mbed to read the temperature from the SEN-11931 and display the temperature in Fahrenheit degrees on the 
LED display in the format of xxx.x. Build your circuit and include all the required information about your hardware design in your lab report. 
You will also need to make the decision on whether pull-up resistors are needed.

Based on the hardware you designed, write a code that takes temperature measurement every 5 seconds and display the temperature in 
Fahrenheit degrees on the 4-bank seven-segment LED display.

Test your digital thermometer and explain your testing process and how you use your test results to confirm that your digital 
thermometer functions properly.

*/
#include "mbed.h"
#include "TMP102.h"
#include <iostream>

using namespace std; 

Serial pc(USBTX, USBRX);

BusOut digselect(p20, p19, p15, p13);
// bus from MSB to LSB: digit4, digit3, digit2, digit1

BusOut digit(p26, p28, p25, p18, p16, p23, p27, p14);
// bus from MSB to LSB: dp, g, f, e, d, c, b, a
 
    
TMP102 temperature(p9, p10, 0x90); //A0 pin is connected to ground

float digit; 
float Ftemp = 0;
float c;

int main()
{
c = temperature.read();

Ftemp = ( 1.8 * c) + 32;
    
  while(1) {
    
    digselect = 0x1; // digit 1 Binary: 0 0 0 1
    wait_ms(1);
    digselect = 0x2; //digit 2 Binary: 0 0 1 0
    wait_ms(1);
    digselect = 0x4; //digit 3 Binary: 0 1 0 0
    wait_ms(1);
    digselect = 0x8; //digit 4 Binary: 1 0 0 0
    wait_ms(1);
    
         
    digit = Ftemp;
    Ftemp.digit();
    
    wait(1);
    printf( "Temperature: %f\n", Ftemp );
    
   
   } //end while
              
   
} //end main