
/**********************************************************************************************************************************

NAME: Kevin Maddox
DATE: 2 JAN 2015

    1. In this part of the Lab 2, you are given a 10kohm linear rotary potentiometer (included) in the kit, 
    and then a resistor with unknown resistance (pick one resistor out of your resistor envelope in the kit). 
    Without any meters, your task is to use the mbed to find out the resistance of the resistor of unknown resistance. 
    Your are free to use any of the LEDs for indication.
    
    2. Design the hardware connection of the potentiometer and the unknown resistors to mbed to produce various voltages 
    to some point of the circuit. Use your mbed to read the voltage at this point. Study the potentiometer that is provided in 
    your kit, research and find the circuit diagram of such potentiometer and how you should connect it to mbed so that 
    you can get various voltage reading from some point of the circuit. 
    You may use the Vout of the mbed platform to provide the consistent voltage to your circuit of the potentiometer 
    and the unknown resistor, but take into consideration (if needed) of limiting current when the potentiometer produce 
    a zero resistance into the circuit. Use the analog input and the Tara Term to display your measurement. Build your circuit 
    and include all the required information about your hardware design in your lab report.
    
    3. Based on the hardware you designed, write a code that takes voltage measurement every 10 seconds and write it to the 
    Tera Terminal. You are also required to find a way to indicate to the user that he/she is free to change the potentiometer 
    setting (no measurement is being currently taken). Your program will read the voltage and display the actual voltage reading 
    to the Tear Terminal. What settings on the potentiometer is important to help you figure out the resistance of the unknown 
    resistor? 
    
    4. Use your system to adjust your potentiometer and take various voltage readings (at least ten including the 
    readings that are important for finding the resistance of the unknown resistor). Include screen shots of your potentiometer 
    positions and also the sreenshots of the voltage readings displayed in the terminal. 
*************************************************************************************************************************************/
#include "mbed.h"

Serial pc(USBTX, USBRX);  //define transmitter and receiver

AnalogOut Aout(p18);  //defines the analog output on pin 18
AnalogIn Ain(p20);    //defines the analog input on pin 20


int main() 
{
pc.printf(" Code will now take voltage measurement every 10 seconds \n");
pc.printf(" and will write it to the Tera Terminal. \n");
pc.printf(" You are free to change the potentiometer setting at anytime. \n");

    while(1) 
    {
       Aout = Ain;
       float c = Aout * 3.3; // puts Aout value to c; Aout takes a floating poing number between 0.0 and 1.0
                             // the actual output voltage on p18 is between 0v=3.3v, we scale this with * 3.3v
       
       
       pc.printf ("%f \n", c);  //prints to Tera Term the Decimal floating point, lowercase from Aout
       
       wait(5);  //wait command before next reading
       

    }
}
