#include "PaceHeart.h"
#include "mbed.h"
#include "Hardware.h"
using namespace std;



PaceHeart::PaceHeart(){
    int p_pacingState = 0;
    int p_pacingMode = 0;
    int p_hysteresis = 0;
    int p_hysteresisInterval = 300;
    int lowrateInterval = 1000;
//Ventricle
    double p_vPaceAmp = 3500.0;
    double p_vPaceWidth = 0.4;
    int p_VRP = 320;
//Atrium (change defaults)
    double p_aPaceAmp = 3500.0;
    double p_aPaceWidth = 0.4;
    int p_ARP = 320;
}

int PaceHeart::get_p_pacingState()
{
    return p_pacingState;
}
int PaceHeart::get_p_pacingMode()
{
    return p_pacingMode;
}
void Pace::set_p_pacingMode(int mode)
{
    p_pacingMode = mode;
    return;
}
int PaceHeart::get_p_hysteresis()
{
    return p_hysteresis;
}
void PaceHeart::set_p_hysteresis(int hysteresis)
{
    p_hysteresis = hysteresis;
    return;
}
int PaceHeart::get_p_hysteresisInterval()
{
    return p_hysteresisInterval;
}
void PaceHeart::set_p_hysteresisInterval(int hysteresisInterval)
{
    p_hysteresisInterval = hysteresisInterval;
    return;
}
int PaceHeart::get_lowrateInterval()
{
    return lowrateInterval;
}
void PaceHeart::set_lowrateInterval(int lowrateInterval)
{
    lowrateInterval = lowrateInterval;
    return;
}
//Ventricle
double PaceHeart::get_p_vPaceAmp()
{
    return p_vPaceAmp;
}
void PaceHeart::set_p_vPaceAmp(double vPaceAmp)
{
    p_vPaceAmp = vPaceAmp;
    return;
}

double PaceHeart::get_p_vPaceWidth()
{
    return p_vPaceWidth;
}
void PaceHeart::set_p_vPaceWidth(double vPaceWidth)
{
    p_vPaceWidth = vPaceWidth;
    return;
}

int PaceHeart::get_p_VRP()
{
    return p_VRP;
}
void PaceHeart::set_p_VRP(int VRP)
{
    p_VRP = VRP;
    return;
}
//Atrium
double PaceHeart::get_p_aPaceAmp()
{
    return p_aPaceAmp;
}
void PaceHeart::set_p_aPaceAmp(double aPaceAmp)
{
    p_aPaceAmp = aPaceAmp;
    return;
}

double PaceHeart::get_p_aPaceWidth()
{
    return p_aPaceWidth;
}
void PaceHeart::set_p_aPaceWidth(double aPaceWidth)
{
    p_aPaceWidth = aPaceWidth;
    return;
}

int PaceHeart::get_p_ARP()
{
    return p_ARP;
}
void PaceHeart::set_p_ARP(int ARP)
{
    p_ARP = ARP;
    return;
}



void PaceHeart::pace_A(double amp, double wid,int pin)
{
    output_pin_A = !output_pin_A ;
    wait(1);



    return;
}

void PaceHeart::pace_A()
{
    double amplitude = get_p_aPaceAmp();
    double width = get_p_aPaceWidth();
    // int output_pin = hardware.get_output_pin; //include the hardware module
    pace_A(amplitude,width,output_pin_A);
    return;
}


void PaceHeart::pace_V(double amp, double wid, int output_pin_V)
{
    output_pin_V = !output_pin_V ;
    wait(2);

    return;
}

void PaceHeart::pace_V()
{
    double amplitude = get_p_vPaceAmp();
    double width = get_p_vPaceWidth();
    // int output_pin = hardware.get_output_pin; //include the hardware module
    pace_V(amplitude,width,output_pin_V);
    return;
}


void PaceHeart::pace(int mode)
{
    set_p_pacingMode(mode);
    switch(mode){
    case 1:  //AOO
           pace_A();
    case 2:  //VOO
           pace_V();
    }
    return;
}

void PaceHeart::pace()
{
    int mode = get_p_pacingMode();
    pace(mode);
    return;
}

bool PaceHeart::amp_inRange(double x)
{
    if (x>=500 && x<=7000)
    {
        return true;
    }
    else
    {
        return false;
    }
}

bool PaceHeart::dur_inRange(double x)
{
    if (x>=0.1 && x<=1.9)
    {
        return true;
    }
    else
    {
        return false;
    }
}

bool PaceHeart::width_inRange(int x)
{
    if (x>=150 && x<=500)
    {
        return true;
    }
    else
    {
        return false;
    }
}
