#include "mbed.h"
#include "Max5250.h" 

 SPI spi(p5, NC, p7); 
 DigitalOut cs(p8);
 Serial dbg3(USBTX, USBRX);
 
int DAC_Setup(void) {
    spi.format(16,0);
    spi.frequency(1000000);
    return 1;
    }

/**********************************************************************
* Configures the command from the data bytes and writes to the SPI  
* MAX5250 command structure: A1,A0, C1,C0, D9..D0, S1,S0
* A1,A0 - DAC addr, C1,C0 = 3 for immediate update, 1 for deferred update
* D9..D0 = 10bit value [Vo = (Vref* D/1024)(Gain)] Gain = 1 in this desgin
* S1,S0 = always zero
*/
int SetDAC(uint8_t *data){
    int cmd;
    
    data[2] &= 3; //Fix to 3 max.
    cmd = (data[1] << 12);
    cmd += (data[2] << 10);
    cmd += (data[3] << 2);
    dbg3.printf("cmd = %0x\n", cmd);
    
    cs = 0;
    spi.write(cmd);
    cs = 1;
    return 1;
    }