#include "mbed.h"
#include "main.h"
#include "USBHID.h"
#include "DigiPot.h"
#include "Max5250.h"
#include "Relay.h"


 USBHID hid;
 HID_REPORT recv, xmit;
 BusOut leds(LED1,LED2,LED3,LED4);


 int main(void) {
    int msgtype;
    leds = 0xf;
    xmit.length=64;
   //Fill the report
   for (int i = 0; i < xmit.length; i++)
        xmit.data[i] =  0xa5;

    pc.printf("Resetting to Room Temp\n");
    PotReset();
   
    pc.printf("Hello from mbed\n");
    
    DAC_Setup();      
    pc.printf("DAC Setup Complete\n");
   
    pc.printf("Relays Resetting\n");
    Def_Relay();
   
 while (1) {
        hid.read(&recv);
        leds = recv.data[0];
        msgtype = recv.data[0];
      
        switch (msgtype) {
        case 0:
        case 1:
        case 2:
            break;
        case 3:
           pc.printf("Going to Resistor set\n");
            SetResist(recv.data);
            break;
        case 4:
           pc.printf("Going to DAC set\n");
            SetDAC(recv.data);
            break;
        case 5:
           pc.printf("Going to Relay set\n");
            Set_Relay(recv.data);
            break;        
        case 6:
           pc.printf("Going to Resistor Chain set\n");
            SetResistChain(recv.data);
            break;        
        default:
            break;
        } //End switch
      
      hid.send(&xmit);   
    } //End while
 } //End Main

