#include "mbed.h"
#include "Relay.h"

Serial dbg2(USBTX,USBRX);
DigitalOut v13_en(p15);
DigitalOut v18_en(p16);
DigitalOut Ext_Sw(p17);
DigitalOut Hpco(p18);

//Set all relays open (NO->Com)
int Def_Relay(void) {
    Hpco = 0;
    Ext_Sw = 0;
    v13_en = 0;
    v18_en = 0;
    return 1;
    }

int Set_Relay(uint8_t *data) {
    data[1] &= 0xf; //Only 4 relays
    data[2] &= 0x1; //Only allow Zero or One
    switch (data[1]) {
        case 1:
            v13_en = data[2];
            dbg2.printf("13.8V = %d\n",data[2]);
            break;
        case 2:
            v18_en = data[2];
            dbg2.printf("18V = %d\n",data[2]);
            break;
        case 3:
            Hpco = data[2];
            dbg2.printf("HPCO = %d\n",data[2]);
            break;
        case 4:
            Ext_Sw = data[2];
            dbg2.printf("Ext SW = %d\n",data[2]);
            break;
        default:
            break;
        }
    return 1;
    }