/* mbed MCP4651 DigiPot Driver Library
 *
 * Copyright (c) 2012, Kevin Kent Trane US Inc
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

#ifndef MCP4651_H
#define MCP4651_H

#include "mbed.h"

// register names
#define MCP4651_VOL_WIPER0  0
#define MCP4651_VOL_WIPER1  1

#define MCP4651_REG_TCON    4



// Command modes
// Left Shifted 2 bits for low nibble
#define MCP4651_WR  0x0 // 00b
#define MCP4651_RD  0xB // 11b
#define MCP4651_INC 0x4 // 01b
#define MCP4651_DEC 0x2 // 10b

// Base Address of MCP4651 
// 0101b + A2:A1:A0:R/W
#define MCP4651_BASE 0x50

class MCP4651 {

public:

    MCP4651(PinName sda, PinName scl, int addr);

//    int SetLed  (int led, int mode);
//    int SetMode (int mask, int mode);
//    int Duty (int channel, float duty);
//    int Period (int channel, float period);
    int SetValue (int wiper, int value);
    int GetValue (int wiper);

protected:

    void _write(int reg, int data);
    int _read(int reg);
    int _addr;
    I2C _i2c;

};


#endif