/* mbed MCP4651 DigiPot Driver Library
 *
 * Copyright (c) 2012, Kevin Kent
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */


#include "MCP4651.h"
#include "mbed.h"

/*
 Constructor, pin names for I2C and the I2C offset address of the device
 */
MCP4651::MCP4651(PinName sda, PinName scl, int addr)
        : _i2c(sda, scl) {

    _i2c.frequency(1000000);

    // Full I2C address = 0101b + A2:A1:A0:R/W
    _addr = MCP4651_BASE + (addr << 1);

}

/* 
Sets the value of the selected wiper
*/

int MCP4651::SetValue (int wiper, int value) {
    int reg;
    if (wiper == 0) {reg = MCP4651_VOL_WIPER0;}
    if (wiper == 1) {reg = MCP4651_VOL_WIPER1 << 4;}
    
    _write(reg, value);

    return(0);
}




// private functions for low level IO

void MCP4651::_write(int reg, int data) {
    char args[2];
    args[0] = reg;
    args[1] = data;
    _i2c.write(_addr, args,2);
}

int MCP4651::_read(int reg) {
    char args[2];
    args[0] = reg;
    _i2c.write(_addr, args, 1);
    _i2c.read(_addr, args, 1);
    return(args[0]);
}





