//
#include "DigiPot.h"
#include "MCP4651.h"

Serial dbg1(USBTX,USBRX);

// Enable pins for PCA9
BusOut Pbus(p14,p13,p12,p11);

// This is the pins used for I2C and the base address of the chip

MCP4651 Chip1(p9, p10, 0x1);
MCP4651 Chip2(p9, p10, 0x2);
MCP4651 Chip3(p9, p10, 0x3);
MCP4651 Chip4(p9, p10, 0x5);
MCP4651 Chip5(p9, p10, 0x6);
MCP4651 Chip6(p9, p10, 0x7);


//  The MCP4651 go to mid scale on reset
//  Use the general call commands to set all pots to zero
//  Set the lowest values pot to approximately 10k
 
int PotReset(void) {
    char wip0[2] = {0x80, 0x0};
    char wip1[2] = {0x90, 0x0};    
    I2C GenCall(p9,p10);
    
    // Reset R1 & R2
    Pbus = 0x1;
    GenCall.write(0x0, wip0, 2);
    GenCall.write(0x0, wip1, 2);
    Chip1.SetValue(0,50); // About 10k on 50k pot
    Chip4.SetValue(0,50);
    
    // Reset R3 & R4
    Pbus = 0x2;
    GenCall.write(0x0, wip0, 2);
    GenCall.write(0x0, wip1, 2);
    Chip1.SetValue(0,50);
    Chip4.SetValue(0,50);
    
    // Reset R5 & R6
    Pbus = 0x4;
    GenCall.write(0x0, wip0, 2);
    GenCall.write(0x0, wip1, 2);
    Chip1.SetValue(0,50);
    Chip4.SetValue(0,50);
    
    // Pbus = 0x8; /* Not Used at this time */
    Pbus = 0;
    return(0);
} // End PotReset

//  Decode the HID report and set the pots
int SetResist( uint8_t *data) {
    int wiper = 0, value = 0;
    dbg1.printf("data[0] = %d\n",data[0]);
    dbg1.printf("data[1] = %d\n",data[1]);
    dbg1.printf("data[2] = %d\n",data[2]);
    dbg1.printf("data[3] = %d\n",data[3]);
    dbg1.printf("data[4] = %d\n",data[4]);
    dbg1.printf("data[5] = %d\n",data[5]);
    if (data[0] != 3) return(1); // should not be here
    if (data[1] == 0) return(1); // Zero = bus disable
    if (data[3] == 0) return(1); // Zero disallowed
    Pbus = data[1];
    if(data[4] > 0) wiper = (data[4] - 1); //Wiper on Device is zero based
    value = data[5]; // Pot value
    
    switch (data[3]) {
        case 1:
            Chip1.SetValue(wiper, value);
            dbg1.printf("Set Pbus = %d, Chip = %d, Pot = %d, Value = %d\n", data[1], data[3], wiper, value);
            break;
        case 2:
            Chip2.SetValue(wiper, value);
            dbg1.printf("Set Pbus = %d, Chip = %d, Pot = %d, Value = %d\n", data[1], data[3], wiper, value);
            break;
        case 3:
            Chip3.SetValue(wiper, value);
            dbg1.printf("Set Pbus = %d, Chip = %d, Pot = %d, Value = %d\n", data[1], data[3], wiper, value);
            break;
        case 4:
            Chip4.SetValue(wiper, value);
            dbg1.printf("Set Pbus = %d, Chip = %d, Pot = %d, Value = %d\n", data[1], data[3], wiper, value);
            break;
        case 5:
            Chip5.SetValue(wiper, value);
            dbg1.printf("Set Pbus = %d, Chip = %d, Pot = %d, Value = %d\n", data[1], data[3], wiper, value);
            break;
        case 6:
            Chip6.SetValue(wiper, value);
            dbg1.printf("Set Pbus = %d, Chip = %d, Pot = %d, Value = %d\n", data[1], data[3], wiper, value);
            break;
        default:
            break;
       }
    dbg1.printf("Resistor Set Done\n");
    data[0] = 0;
    Pbus = 0;
    return(0);
} // End SetResist

//  Decode the HID report and set the pots
//  This sets all pots in one string from the same USB message
//  The HID report is the same format as SetResist except:
//  the Chip#, Pot#, Value must be set for all 6 pots in the string.
//  Only the Value is used and Chip# must == The top chip in the string.  
int SetResistChain( uint8_t *data) {

    dbg1.printf("Starting string set\n");
    dbg1.printf("data[0] = %d\n",data[0]);


    if (data[0] != 6) return(1);
    if (data[1] == 0) return(1); // Zero = bus disable
    if (data[3] == 0) return(1); // Zero = disallowed chip #
    Pbus = data[1];
    dbg1.printf("Set Pbus = %d\n", data[1]);
   if (data[3] == 1) {
            Chip1.SetValue(0, data[5]);
            Chip1.SetValue(1, data[8]);
            dbg1.printf("Chip1: Wip0 = %d, Wip1 = %d\n", data[5], data[8]);
  
            Chip2.SetValue(0, data[11]);
            Chip2.SetValue(1, data[14]);
            dbg1.printf("Chip2: Wip0 = %d, Wip1 = %d\n", data[11], data[14]);
            
            Chip3.SetValue(0, data[17]);
            Chip3.SetValue(1, data[20]);
            dbg1.printf("Chip3: Wip0 = %d, Wip1 = %d\n", data[17], data[20]);
    } 
    
    if (data[3] == 4) {
            Chip4.SetValue(0, data[5]);
            Chip4.SetValue(1, data[8]);
            dbg1.printf("Chip4: Wip0 = %d, Wip1 = %d\n", data[5], data[8]);
  
            Chip5.SetValue(0, data[11]);
            Chip5.SetValue(1, data[14]);
            dbg1.printf("Chip5: Wip0 = %d, Wip1 = %d\n", data[11], data[14]);
            
            Chip6.SetValue(0, data[17]);
            Chip6.SetValue(1, data[20]);
            dbg1.printf("Chip6: Wip0 = %d, Wip1 = %d\n", data[17], data[20]);
    } 
    dbg1.printf("Resistor Chain Set Done\n");
    data[0] = 0;
    Pbus = 0;
    return(0);
} // End SetResistChain

