// STM32L432KC
// https://os.mbed.com/platforms/ST-Nucleo-L432KC/


#include "mbed.h"
#include "PwmIn.h"

#define PWM_FAN_1       D9
#define TACHO_FAN_1     D11

#define PWM_FREQUENCY   25000
#define DUTY_CYCLE      50

PwmOut  mypwm1(PWM_FAN_1);

PwmIn   tacho1(TACHO_FAN_1);

int main() {
    
    //PWM period

    mypwm1.period_us((int) (PWM_FREQUENCY/25));
    mypwm1.pulsewidth_us((int)(PWM_FREQUENCY*DUTY_CYCLE/100));       // Not lower than 10 us
  
    printf("PWM Duty is set to %.2f %%\n", mypwm1.read() * 100);
    float speed1;
    while(1) {
        speed1 = tacho1.period() * 1000;
        printf("Speed: %f\n",speed1);
    }
}
